/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.event.TableActionEvent;
import com.arsdigita.bebop.event.TableActionListener;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.table.TableColumn;
import com.arsdigita.bebop.table.TableColumnModel;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.SecurityManager;
import com.arsdigita.cms.contenttypes.GenericContact;
import com.arsdigita.cms.contenttypes.GenericContactTypeCollection;
import com.arsdigita.cms.contenttypes.GenericPerson;
import com.arsdigita.cms.contenttypes.GenericPersonContactCollection;
import com.arsdigita.cms.contenttypes.util.ContenttypesGlobalizationUtil;
import com.arsdigita.cms.dispatcher.ItemResolver;
import com.arsdigita.cms.dispatcher.Utilities;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.globalization.GlobalizationHelper;
import com.arsdigita.util.LockableImpl;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class GenericPersonContactTable
extends Table
implements TableActionListener {
    private static final Logger s_log = Logger.getLogger(GenericPersonContactTable.class);
    private static final String TABLE_COL_EDIT = "table_col_edit";
    private static final String TABLE_COL_DEL = "table_col_del";
    private static final String TABLE_COL_UP = "table_col_up";
    private static final String TABLE_COL_DOWN = "table_col_down";
    private ItemSelectionModel m_itemModel;

    public GenericPersonContactTable(ItemSelectionModel itemModel) {
        s_log.debug((Object)"Constructor begin...");
        this.m_itemModel = itemModel;
        this.setEmptyView((Component)new Label(ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.person.contacts.none")));
        TableColumnModel tab_model = this.getColumnModel();
        tab_model.add(new TableColumn(0, ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.person.contact.type").localize()));
        tab_model.add(new TableColumn(1, ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.person.contact.title").localize(), (Object)TABLE_COL_EDIT));
        tab_model.add(new TableColumn(2, ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.person.contact.del").localize(), (Object)TABLE_COL_DEL));
        tab_model.add(new TableColumn(3, ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.person_contact.up").localize(), (Object)TABLE_COL_UP));
        tab_model.add(new TableColumn(4, ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.person_contact.down").localize(), (Object)TABLE_COL_DOWN));
        this.setModelBuilder(new GenericPersonTableModelBuilder(itemModel));
        tab_model.get(1).setCellRenderer((TableCellRenderer)new EditCellRenderer());
        tab_model.get(2).setCellRenderer((TableCellRenderer)new DeleteCellRenderer());
        tab_model.get(3).setCellRenderer((TableCellRenderer)new UpCellRenderer());
        tab_model.get(4).setCellRenderer((TableCellRenderer)new DownCellRenderer());
        this.addTableActionListener(this);
        s_log.debug((Object)"Constructor finished.");
    }

    public void cellSelected(TableActionEvent evt) {
        PageState state = evt.getPageState();
        GenericContact contact = new GenericContact(new BigDecimal(evt.getRowKey().toString()));
        GenericPerson person = (GenericPerson)this.m_itemModel.getSelectedObject(state);
        GenericPersonContactCollection contacts = person.getContacts();
        TableColumn col = this.getColumnModel().get(evt.getColumn().intValue());
        if (!col.getHeaderKey().toString().equals(TABLE_COL_EDIT)) {
            if (col.getHeaderKey().toString().equals(TABLE_COL_DEL)) {
                person.removeContact(contact);
            } else if (col.getHeaderKey().toString().equals(TABLE_COL_UP)) {
                contacts.swapWithPrevious(contact);
            } else if (col.getHeaderKey().toString().equals(TABLE_COL_DOWN)) {
                contacts.swapWithNext(contact);
            }
        }
    }

    public void headSelected(TableActionEvent e) {
        throw new UnsupportedOperationException("Not Implemented");
    }

    private class DownCellRenderer
    extends LockableImpl
    implements TableCellRenderer {
        private DownCellRenderer() {
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int col) {
            GenericPerson person = (GenericPerson)GenericPersonContactTable.this.m_itemModel.getSelectedObject(state);
            GenericPersonContactCollection contacts = person.getContacts();
            if (contacts.size() - 1L == (long)row) {
                s_log.debug((Object)"Row is last row in table, don't show down-link");
                return new Label("");
            }
            ControlLink link = new ControlLink("down");
            return link;
        }
    }

    private class UpCellRenderer
    extends LockableImpl
    implements TableCellRenderer {
        private UpCellRenderer() {
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int col) {
            if (0 == row) {
                s_log.debug((Object)"Row is first row in table, don't show up-link");
                return new Label("");
            }
            ControlLink link = new ControlLink("up");
            return link;
        }
    }

    private class DeleteCellRenderer
    extends LockableImpl
    implements TableCellRenderer {
        private DeleteCellRenderer() {
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            SecurityManager sm = Utilities.getSecurityManager(state);
            GenericPerson person = (GenericPerson)GenericPersonContactTable.this.m_itemModel.getSelectedObject(state);
            boolean canDelete = sm.canAccess(state.getRequest(), "delete_item", (ContentItem)person);
            if (canDelete) {
                ControlLink link = new ControlLink(value.toString());
                link.setConfirmation((String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.person.confirm_delete").localize());
                return link;
            }
            return new Label(value.toString());
        }
    }

    private class EditCellRenderer
    extends LockableImpl
    implements TableCellRenderer {
        private EditCellRenderer() {
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            GenericContact contact;
            SecurityManager sm = Utilities.getSecurityManager(state);
            GenericPerson person = (GenericPerson)GenericPersonContactTable.this.m_itemModel.getSelectedObject(state);
            boolean canEdit = sm.canAccess(state.getRequest(), "edit_item", (ContentItem)person);
            if (canEdit) {
                GenericContact contact2;
                try {
                    contact2 = new GenericContact((BigDecimal)key);
                }
                catch (DataObjectNotFoundException ex) {
                    return new Label(value.toString());
                }
                ContentSection section = CMS.getContext().getContentSection();
                ItemResolver resolver = section.getItemResolver();
                Link link = new Link(String.format("%s (%s)", value.toString(), contact2.getLanguage()), resolver.generateItemURL(state, contact2, section, contact2.getVersion()));
                return link;
            }
            try {
                contact = new GenericContact((BigDecimal)key);
            }
            catch (DataObjectNotFoundException ex) {
                return new Label(value.toString());
            }
            Label label = new Label(String.format("%s (%s)", value.toString(), contact.getLanguage()));
            return label;
        }
    }

    private class GenericPersonTableModel
    implements TableModel {
        private final int MAX_DESC_LENGTH = 25;
        private Table m_table;
        private GenericPersonContactCollection m_contactCollection;
        private GenericContact m_contact;
        private GenericContactTypeCollection contacttypes = new GenericContactTypeCollection();

        private GenericPersonTableModel(Table t, PageState ps, GenericPerson person) {
            s_log.debug((Object)"Creating table model...");
            this.m_table = t;
            this.m_contactCollection = person.getContacts();
            s_log.debug((Object)"Created table model...");
        }

        public int getColumnCount() {
            return this.m_table.getColumnModel().size();
        }

        public boolean nextRow() {
            s_log.debug((Object)"Next row?");
            if (this.m_contactCollection != null && this.m_contactCollection.next()) {
                this.m_contact = this.m_contactCollection.getContact();
                s_log.debug((Object)"Yes.");
                return true;
            }
            s_log.debug((Object)"No.");
            return false;
        }

        public Object getElementAt(int columnIndex) {
            s_log.debug((Object)String.format("Getting element at %d...", columnIndex));
            switch (columnIndex) {
                case 0: {
                    s_log.debug((Object)String.format("Getting human readable contact type for contact type \"%s\"...", this.m_contactCollection.getContactType()));
                    String lang = GlobalizationHelper.getNegotiatedLocale().getLanguage();
                    if (this.contacttypes.size() <= 0L) {
                        s_log.warn((Object)"No contact entry types found. Using key as fallback.");
                        return this.m_contactCollection.getContactType();
                    }
                    if (this.contacttypes.getRelationAttribute(this.m_contactCollection.getContactType(), lang) == null) {
                        s_log.debug((Object)String.format("No human readable name found for '%s' for language '%s' Using key.", this.m_contactCollection.getContactType(), lang));
                        return this.m_contactCollection.getContactType();
                    }
                    s_log.debug((Object)String.format("Human readable contact type is: \"%s\"...", new Object[]{this.contacttypes.getRelationAttribute(this.m_contactCollection.getContactType(), lang)}));
                    String name = this.contacttypes.getRelationAttribute(this.m_contactCollection.getContactType(), lang).getName();
                    return name;
                }
                case 1: {
                    return this.m_contact.getTitle();
                }
                case 2: {
                    return GlobalizationUtil.globalize("cms.ui.delete").localize();
                }
            }
            return null;
        }

        public Object getKeyAt(int columnIndex) {
            return this.m_contact.getID();
        }
    }

    private class GenericPersonTableModelBuilder
    extends LockableImpl
    implements TableModelBuilder {
        private ItemSelectionModel m_itemModel;

        public GenericPersonTableModelBuilder(ItemSelectionModel itemModel) {
            s_log.debug((Object)"Creating table model builder...");
            this.m_itemModel = itemModel;
            s_log.debug((Object)"Created table model builder.");
        }

        public TableModel makeModel(Table table, PageState state) {
            s_log.debug((Object)"Making model...");
            table.getRowSelectionModel().clearSelection(state);
            GenericPerson person = (GenericPerson)this.m_itemModel.getSelectedObject(state);
            s_log.debug((Object)"Made model...");
            return new GenericPersonTableModel(table, state, person);
        }
    }
}

