/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.parameters.DateParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.cms.ContentPage;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.Folder;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.contenttypes.GenericPerson;
import com.arsdigita.cms.contenttypes.GenericPersonBundle;
import com.arsdigita.cms.contenttypes.ui.GenericPersonPropertyForm;
import com.arsdigita.cms.ui.authoring.ApplyWorkflowFormSection;
import com.arsdigita.cms.ui.authoring.BasicPageForm;
import com.arsdigita.cms.ui.authoring.CreationSelector;
import com.arsdigita.cms.ui.authoring.LanguageWidget;
import com.arsdigita.cms.ui.authoring.PageCreate;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.util.Assert;
import java.util.Date;

public class GenericPersonCreate
extends PageCreate {
    private static final String SURNAME = "surname";
    private static final String GIVENNAME = "givenname";
    private static final String TITLEPRE = "titlepre";
    private static final String TITLEPOST = "titlepost";

    public GenericPersonCreate(ItemSelectionModel itemModel, CreationSelector parent) {
        super(itemModel, parent);
    }

    @Override
    protected void addWidgets() {
        ContentType type = this.getItemSelectionModel().getContentType();
        this.m_workflowSection = new ApplyWorkflowFormSection(type);
        this.add((Component)this.m_workflowSection, 128);
        this.add((Component)new Label(GlobalizationUtil.globalize("cms.ui.authoring.content_type")));
        this.add((Component)new Label(type.getLabel()));
        this.add((Component)new Label(GlobalizationUtil.globalize("cms.ui.language.field")));
        this.add((Component)new LanguageWidget("language"));
        GenericPersonPropertyForm.mandatoryFieldWidgets(this);
        if (!ContentSection.getConfig().getHideLaunchDate()) {
            this.add((Component)new Label(GlobalizationUtil.globalize("cms.ui.authoring.page_launch_date")));
            DateParameter launchDateParam = new DateParameter("launchDate");
            com.arsdigita.bebop.form.Date launchDate = new com.arsdigita.bebop.form.Date((ParameterModel)launchDateParam);
            if (ContentSection.getConfig().getRequireLaunchDate()) {
                launchDate.addValidationListener((ParameterListener)new BasicPageForm.LaunchDateValidationListener(this));
                launchDateParam.setDefaultValue((Object)new Date());
            }
            this.add((Component)launchDate);
        }
    }

    @Override
    public void validate(FormSectionEvent e) throws FormProcessException {
        Folder f = this.m_parent.getFolder(e.getPageState());
        Assert.exists((Object)f);
        this.validateNameUniqueness(f, e, GenericPerson.urlSave(this.getItemName(e)));
    }

    @Override
    public void process(FormSectionEvent e) throws FormProcessException {
        FormData data = e.getFormData();
        PageState state = e.getPageState();
        ContentSection section = this.m_parent.getContentSection(state);
        Folder folder = this.m_parent.getFolder(state);
        String fullName = this.getItemName(e);
        Assert.exists((Object)((Object)section), ContentSection.class);
        ContentPage item = this.createContentPage(state);
        item.setLanguage((String)data.get((Object)"language"));
        item.setName(GenericPerson.urlSave(fullName));
        item.setTitle(fullName);
        if (!ContentSection.getConfig().getHideLaunchDate()) {
            item.setLaunchDate((Date)data.get((Object)"launchDate"));
        }
        GenericPersonBundle bundle = new GenericPersonBundle(item);
        bundle.setParent((ACSObject)folder);
        bundle.setContentSection(this.m_parent.getContentSection(state));
        bundle.save();
        this.m_workflowSection.applyWorkflow(state, item);
        GenericPerson person = new GenericPerson(item.getOID());
        person.setTitlePre(data.getString((Object)TITLEPRE));
        person.setGivenName(data.getString((Object)GIVENNAME));
        person.setSurname(data.getString((Object)SURNAME));
        person.setTitlePost(data.getString((Object)TITLEPOST));
        person.save();
        this.m_parent.editItem(state, item);
    }

    private String getItemName(FormSectionEvent e) {
        FormData data = e.getFormData();
        String givenName = data.getString((Object)GIVENNAME);
        String surname = data.getString((Object)SURNAME);
        return String.format("%s %s", surname, givenName);
    }
}

