/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ExtraXMLGenerator;
import com.arsdigita.cms.contenttypes.GenericContact;
import com.arsdigita.cms.contenttypes.GenericPerson;
import com.arsdigita.cms.contenttypes.GenericPersonContactCollection;
import com.arsdigita.cms.dispatcher.SimpleXMLGenerator;
import com.arsdigita.globalization.GlobalizationHelper;
import com.arsdigita.xml.Element;

public class GenericPersonExtraXmlGenerator
implements ExtraXMLGenerator {
    @Override
    public void generateXML(ContentItem item, Element element, PageState state) {
        if (!(item instanceof GenericPerson)) {
            throw new IllegalArgumentException("The GenericPersonExtraXmlGenerator can only process instances of GenericPerson");
        }
        GenericPerson person = (GenericPerson)item;
        GenericPersonContactCollection contacts = person.getContacts();
        Element contactsElem = element.newChildElement("contacts");
        while (contacts.next()) {
            GenericContact contact = contacts.getContact(GlobalizationHelper.getNegotiatedLocale().getLanguage());
            this.generateContactXml(contactsElem, contact, state);
        }
    }

    private void generateContactXml(Element contactsElem, GenericContact contact, PageState state) {
        XmlGenerator generator = new XmlGenerator(contact);
        generator.setItemElemName("contact", "");
        generator.addItemAttribute("contactType", contact.getContactType());
        generator.generateXML(state, contactsElem, "");
    }

    @Override
    public void addGlobalStateParams(Page page) {
    }

    @Override
    public void setListMode(boolean listMode) {
    }

    private class XmlGenerator
    extends SimpleXMLGenerator {
        private ContentItem item;

        public XmlGenerator(ContentItem item) {
            this.item = item;
        }

        @Override
        public ContentItem getContentItem(PageState state) {
            return this.item;
        }
    }
}

