/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.table.TableColumn;
import com.arsdigita.bebop.table.TableColumnModel;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.contenttypes.GenericOrganizationalUnit;
import com.arsdigita.cms.contenttypes.GenericOrganizationalUnitBundleCollection;
import com.arsdigita.cms.contenttypes.GenericPerson;
import com.arsdigita.cms.contenttypes.util.ContenttypesGlobalizationUtil;
import com.arsdigita.cms.dispatcher.ItemResolver;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.util.LockableImpl;
import java.math.BigDecimal;

public class GenericPersonOrgaUnitsTable
extends Table {
    private static final String TABLE_COL_EDIT = "table_col_edit";
    private static final String TABLE_COL_YEAR = "table_col_year";
    private static final String TABLE_COL_TYPE = "table_col_type";
    private ItemSelectionModel itemModel;

    public GenericPersonOrgaUnitsTable(ItemSelectionModel itemModel) {
        this.itemModel = itemModel;
        this.setEmptyView((Component)new Label(ContenttypesGlobalizationUtil.globalize("person.ui.orgaunits.none")));
        TableColumnModel columnModel = this.getColumnModel();
        columnModel.add(new TableColumn(0, ContenttypesGlobalizationUtil.globalize("person.ui.orgaunits.columns.name").localize(), (Object)TABLE_COL_EDIT));
        columnModel.add(new TableColumn(2, ContenttypesGlobalizationUtil.globalize("person.ui.orgaunits.columns.type").localize(), (Object)TABLE_COL_TYPE));
        this.setModelBuilder(new ModelBuilder(itemModel));
        columnModel.get(0).setCellRenderer((TableCellRenderer)new EditCellRenderer());
    }

    private class EditCellRenderer
    extends LockableImpl
    implements TableCellRenderer {
        private EditCellRenderer() {
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            GenericOrganizationalUnit orgaUnit = new GenericOrganizationalUnit((BigDecimal)key);
            ContentSection section = CMS.getContext().getContentSection();
            ItemResolver resolver = section.getItemResolver();
            Link link = new Link(value.toString(), resolver.generateItemURL(state, orgaUnit, section, orgaUnit.getVersion()));
            return link;
        }
    }

    private class Model
    implements TableModel {
        private final Table table;
        private final GenericOrganizationalUnitBundleCollection orgaUnits;

        public Model(Table table, PageState state, GenericPerson person) {
            this.table = table;
            this.orgaUnits = new GenericOrganizationalUnitBundleCollection((DataCollection)person.getGenericPersonBundle().get("organizationalunits"));
        }

        public int getColumnCount() {
            return this.table.getColumnModel().size();
        }

        public boolean nextRow() {
            boolean ret = this.orgaUnits != null && this.orgaUnits.next();
            return ret;
        }

        public Object getElementAt(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.orgaUnits.getGenericOrganizationalUnit().getTitle();
                }
                case 1: {
                    return ((DataObject)this.orgaUnits.getGenericOrganizationalUnit().get("type")).get("label");
                }
            }
            return null;
        }

        public Object getKeyAt(int columnIndex) {
            return this.orgaUnits.getGenericOrganizationalUnit().getID();
        }
    }

    private class ModelBuilder
    extends LockableImpl
    implements TableModelBuilder {
        private final ItemSelectionModel itemModel;

        public ModelBuilder(ItemSelectionModel itemModel) {
            this.itemModel = itemModel;
        }

        public TableModel makeModel(Table table, PageState state) {
            table.getRowSelectionModel().clearSelection(state);
            GenericPerson person = (GenericPerson)this.itemModel.getSelectedItem(state);
            return new Model(table, state, person);
        }
    }
}

