/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SegmentedPanel;
import com.arsdigita.cms.ContentPage;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.contenttypes.GenericPerson;
import com.arsdigita.cms.contenttypes.ui.GenericPersonAliasPropertiesStep;
import com.arsdigita.cms.contenttypes.ui.GenericPersonPropertyForm;
import com.arsdigita.cms.contenttypes.util.ContenttypesGlobalizationUtil;
import com.arsdigita.cms.ui.authoring.AuthoringKitWizard;
import com.arsdigita.cms.ui.authoring.SimpleEditStep;
import com.arsdigita.cms.ui.workflow.WorkflowLockedComponentAccess;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.kernel.ui.DomainObjectSelectionModel;
import com.arsdigita.toolbox.ui.DomainObjectPropertySheet;
import java.text.DateFormat;

public class GenericPersonPropertiesStep
extends SimpleEditStep {
    public static final String EDIT_SHEET_NAME = "edit";

    public GenericPersonPropertiesStep(ItemSelectionModel itemModel, AuthoringKitWizard parent) {
        super(itemModel, parent);
        SegmentedPanel segmentedPanel = new SegmentedPanel();
        this.setDefaultEditKey(EDIT_SHEET_NAME);
        SimpleEditStep basicProperties = new SimpleEditStep(itemModel, parent, EDIT_SHEET_NAME);
        GenericPersonPropertyForm editBasicSheet = new GenericPersonPropertyForm(itemModel, this);
        basicProperties.add(EDIT_SHEET_NAME, (String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.person.edit_basic_properties").localize(), new WorkflowLockedComponentAccess((Component)editBasicSheet, itemModel), editBasicSheet.getSaveCancelSection().getCancelButton());
        basicProperties.setDisplayComponent(GenericPersonPropertiesStep.getGenericPersonPropertySheet(itemModel));
        segmentedPanel.addSegment((Component)new Label((String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.person.basic_properties").localize()), (Component)basicProperties);
        GenericPersonAliasPropertiesStep aliasStep = new GenericPersonAliasPropertiesStep(itemModel, parent);
        segmentedPanel.addSegment((Component)new Label((String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.person.alias").localize()), (Component)aliasStep);
        this.setDisplayComponent((Component)segmentedPanel);
    }

    public static Component getGenericPersonPropertySheet(ItemSelectionModel itemModel) {
        DomainObjectPropertySheet sheet = new DomainObjectPropertySheet((DomainObjectSelectionModel)itemModel);
        sheet.add(ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.person.surname"), "surname");
        sheet.add(ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.person.givenname"), "givenname");
        sheet.add(ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.person.titlepre"), "titlepre");
        sheet.add(ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.person.titlepost"), "titlepost");
        sheet.add(ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.person.birthdate"), "birthdate", new DomainObjectPropertySheet.AttributeFormatter(){

            public String format(DomainObject item, String attribute, PageState state) {
                GenericPerson person = (GenericPerson)item;
                if (person.getBirthdate() != null) {
                    return DateFormat.getDateInstance(1).format(person.getBirthdate());
                }
                return (String)ContenttypesGlobalizationUtil.globalize("cms.ui.unknown").localize();
            }
        });
        sheet.add(ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.person.gender"), "gender", new DomainObjectPropertySheet.AttributeFormatter(){

            public String format(DomainObject item, String attribute, PageState state) {
                GenericPerson person = (GenericPerson)item;
                if (person.getGender() != null) {
                    return (String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.person.gender." + person.getGender().toLowerCase()).localize();
                }
                return (String)ContenttypesGlobalizationUtil.globalize("cms.ui.unknown").localize();
            }
        });
        if (!ContentSection.getConfig().getHideLaunchDate()) {
            sheet.add(ContenttypesGlobalizationUtil.globalize("cms.ui.authoring.page_launch_date"), "launchDate", new DomainObjectPropertySheet.AttributeFormatter(){

                public String format(DomainObject item, String attribute, PageState state) {
                    ContentPage page = (ContentPage)item;
                    if (page.getLaunchDate() != null) {
                        return DateFormat.getDateInstance(1).format(page.getLaunchDate());
                    }
                    return (String)ContenttypesGlobalizationUtil.globalize("cms.ui.unknown").localize();
                }
            });
        }
        sheet.add(ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.person.description"), "pageDescription");
        return sheet;
    }
}

