/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.DateParameter;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.contenttypes.GenericPerson;
import com.arsdigita.cms.contenttypes.ui.GenericPersonPropertiesStep;
import com.arsdigita.cms.contenttypes.util.ContenttypesGlobalizationUtil;
import com.arsdigita.cms.ui.authoring.BasicPageForm;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.log4j.Logger;

public class GenericPersonPropertyForm
extends BasicPageForm
implements FormProcessListener,
FormInitListener,
FormSubmissionListener {
    private static final Logger s_log = Logger.getLogger(GenericPersonPropertyForm.class);
    private GenericPersonPropertiesStep m_step;
    public static final String PERSON = "person";
    public static final String SURNAME = "surname";
    public static final String GIVENNAME = "givenname";
    public static final String TITLEPRE = "titlepre";
    public static final String TITLEPOST = "titlepost";
    public static final String BIRTHDATE = "birthdate";
    public static final String GENDER = "gender";
    public static final String DESCRIPTION = "pageDescription";
    public static final String ID = "Person_edit";

    public GenericPersonPropertyForm(ItemSelectionModel itemModel) {
        this(itemModel, null);
    }

    public GenericPersonPropertyForm(ItemSelectionModel itemModel, GenericPersonPropertiesStep step) {
        super(ID, itemModel);
        this.m_step = step;
        this.addSubmissionListener(this);
    }

    @Override
    protected void addWidgets() {
        super.addWidgets();
        GenericPersonPropertyForm.mandatoryFieldWidgets(this);
        this.add((Component)new Label((String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.person.birthdate").localize()));
        DateParameter birthdateParam = new DateParameter(BIRTHDATE);
        com.arsdigita.bebop.form.Date birthdate = new com.arsdigita.bebop.form.Date((ParameterModel)birthdateParam);
        GregorianCalendar today = new GregorianCalendar();
        birthdate.setYearRange(1900, today.get(1));
        this.add((Component)birthdate);
        this.add((Component)new Label((String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.person.gender").localize()));
        StringParameter genderParam = new StringParameter(GENDER);
        SingleSelect gender = new SingleSelect((ParameterModel)genderParam);
        gender.addOption(new Option("", (Component)new Label((String)ContenttypesGlobalizationUtil.globalize("cms.ui.select_one").localize())));
        gender.addOption(new Option("f", (Component)new Label((String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.person.gender.f").localize())));
        gender.addOption(new Option("m", (Component)new Label((String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.person.gender.m").localize())));
        this.add((Component)gender);
        this.add((Component)new Label((String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.person.description").localize()));
        StringParameter descriptionParam = new StringParameter(DESCRIPTION);
        TextArea description = new TextArea((ParameterModel)descriptionParam);
        description.setCols(50);
        description.setRows(5);
        this.add((Component)description);
    }

    public static void mandatoryFieldWidgets(FormSection form) {
        form.add((Component)new Label((String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.person.titlepre").localize()));
        StringParameter titlepreParam = new StringParameter(TITLEPRE);
        TextField titlepre = new TextField((ParameterModel)titlepreParam);
        form.add((Component)titlepre);
        form.add((Component)new Label((String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.person.surname").localize()));
        StringParameter surnameParam = new StringParameter(SURNAME);
        surnameParam.addParameterListener((ParameterListener)new NotNullValidationListener());
        TextField surname = new TextField((ParameterModel)surnameParam);
        form.add((Component)surname);
        form.add((Component)new Label((String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.person.givenname").localize()));
        StringParameter givennameParam = new StringParameter(GIVENNAME);
        TextField givenname = new TextField((ParameterModel)givennameParam);
        form.add((Component)givenname);
        form.add((Component)new Label((String)ContenttypesGlobalizationUtil.globalize("cms.contenttypes.ui.person.titlepost").localize()));
        StringParameter titlepostParam = new StringParameter(TITLEPOST);
        TextField titlepost = new TextField((ParameterModel)titlepostParam);
        form.add((Component)titlepost);
    }

    @Override
    public void init(FormSectionEvent fse) {
        FormData data = fse.getFormData();
        GenericPerson person = (GenericPerson)super.initBasicWidgets(fse);
        data.put((Object)TITLEPRE, (Object)person.getTitlePre());
        data.put((Object)SURNAME, (Object)person.getSurname());
        data.put((Object)GIVENNAME, (Object)person.getGivenName());
        data.put((Object)TITLEPOST, (Object)person.getTitlePost());
        data.put((Object)BIRTHDATE, (Object)person.getBirthdate());
        data.put((Object)GENDER, (Object)person.getGender());
        data.put((Object)DESCRIPTION, (Object)person.getDescription());
    }

    public void submitted(FormSectionEvent fse) {
        if (this.m_step != null && this.getSaveCancelSection().getCancelButton().isSelected(fse.getPageState())) {
            this.m_step.cancelStreamlinedCreation(fse.getPageState());
        }
    }

    @Override
    public void process(FormSectionEvent fse) {
        FormData data = fse.getFormData();
        GenericPerson person = (GenericPerson)super.processBasicWidgets(fse);
        if (person != null && this.getSaveCancelSection().getSaveButton().isSelected(fse.getPageState())) {
            person.setTitlePre((String)data.get((Object)TITLEPRE));
            person.setSurname((String)data.get((Object)SURNAME));
            person.setGivenName((String)data.get((Object)GIVENNAME));
            person.setTitlePost((String)data.get((Object)TITLEPOST));
            person.setBirthdate((Date)data.get((Object)BIRTHDATE));
            person.setGender((String)data.get((Object)GENDER));
            person.setDescription((String)data.get((Object)DESCRIPTION));
            person.save();
        }
        if (this.m_step != null) {
            this.m_step.maybeForwardToNextStep(fse.getPageState());
        }
    }
}

