/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.contenttypes.ui.LinkPropertyForm;
import com.arsdigita.cms.contenttypes.ui.LinkSelectionModel;
import com.arsdigita.cms.contenttypes.ui.LinkTable;
import com.arsdigita.cms.contenttypes.ui.ResettableContainer;
import com.arsdigita.cms.ui.authoring.AuthoringKitWizard;
import com.arsdigita.cms.ui.workflow.WorkflowLockedContainer;

public abstract class LinkPropertiesStep
extends ResettableContainer {
    private AuthoringKitWizard m_parent;
    private ItemSelectionModel m_itemModel;
    private BigDecimalParameter m_linkParam = new BigDecimalParameter("link");
    private LinkSelectionModel m_linkModel = new LinkSelectionModel(this.m_linkParam);

    public LinkPropertiesStep(ItemSelectionModel itemModel, AuthoringKitWizard parent) {
        this.m_itemModel = itemModel;
        this.m_parent = parent;
        this.setLinkSelectionModel();
        this.add(this.getDisplayComponent());
        Form form = new Form("linkEditForm");
        form.add((Component)this.getEditSheet());
        WorkflowLockedContainer edit = new WorkflowLockedContainer(itemModel);
        edit.add((Component)form);
        this.add((Component)edit);
    }

    protected void setLinkSelectionModel() {
        this.setLinkSelectionModel(new LinkSelectionModel(this.m_linkParam));
    }

    protected void setLinkSelectionModel(LinkSelectionModel linkModel) {
        this.m_linkModel = linkModel;
    }

    protected LinkSelectionModel getLinkSelectionModel() {
        return this.m_linkModel;
    }

    protected ItemSelectionModel getItemSelectionModel() {
        return this.m_itemModel;
    }

    protected BigDecimalParameter getLinkParam() {
        return this.m_linkParam;
    }

    public Component getDisplayComponent() {
        SimpleContainer container = new SimpleContainer();
        container.add((Component)new LinkTable(this.m_itemModel, this.m_linkModel));
        return container;
    }

    protected FormSection getEditSheet() {
        return new LinkPropertyForm(this.m_itemModel, this.m_linkModel);
    }

    @Override
    public void register(Page p) {
        super.register(p);
        p.addComponentStateParam((Component)this, (ParameterModel)this.m_linkParam);
    }
}

