/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SaveCancelSection;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.FormValidationListener;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.form.CheckboxGroup;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.RadioGroup;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.cms.ContentBundle;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.contenttypes.Link;
import com.arsdigita.cms.contenttypes.ui.LinkSelectionModel;
import com.arsdigita.cms.ui.ItemSearchWidget;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.util.Assert;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.web.Web;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.TooManyListenersException;
import org.apache.log4j.Logger;

public class LinkPropertyForm
extends FormSection
implements FormInitListener,
FormProcessListener,
FormValidationListener,
FormSubmissionListener {
    private static final Logger s_log = Logger.getLogger(LinkPropertyForm.class);
    public static final String ID = "link_edit";
    public static final String SSL_PROTOCOL = "https://";
    public static final String HTTP_PROTOCOL = "http://";
    private TextArea m_description;
    private TextField m_title;
    private TextField m_targetURI;
    private RadioGroup m_linkType;
    private CheckboxGroup m_URIOption;
    protected ItemSelectionModel m_itemModel;
    private LinkSelectionModel m_linkModel;
    private SaveCancelSection m_saveCancelSection;
    private ItemSearchWidget m_itemSearch;
    private TextField m_itemParams;
    private ContentType m_contentType;
    protected final String ITEM_SEARCH = "contentItem";

    public LinkPropertyForm(ItemSelectionModel itemModel, LinkSelectionModel link) {
        this(itemModel, link, null);
    }

    public LinkPropertyForm(ItemSelectionModel itemModel, LinkSelectionModel link, ContentType contentType) {
        super((Container)new ColumnPanel(2));
        s_log.debug((Object)"property form constructor");
        this.m_linkModel = link;
        this.m_itemModel = itemModel;
        this.m_contentType = contentType;
        this.addWidgets();
        this.addSaveCancelSection();
        this.addInitListener(this);
        this.addValidationListener(this);
        this.addProcessListener(this);
        this.addSubmissionListener(this);
    }

    protected void addWidgets() {
        this.m_title = new TextField("title");
        this.m_title.addValidationListener((ParameterListener)new NotNullValidationListener());
        this.add((Component)new Label(GlobalizationUtil.globalize("cms.contenttypes.ui.title")));
        this.add((Component)this.m_title);
        this.m_description = new TextArea("description");
        this.m_description.setCols(40);
        this.m_description.setRows(5);
        this.add((Component)new Label(GlobalizationUtil.globalize("cms.contenttypes.ui.description")));
        this.add((Component)this.m_description);
        this.add((Component)new Label("<script language=\"javascript\">\n<!-- \nfunction toggle_link_fields(status) { \n//  document.forms['linkEditForm'].targetURI.disabled = status; \n//  document.forms['linkEditForm'].openOption.disabled = status; \n//  document.forms['linkEditForm'].contentItem.disabled = !status; \n//  document.forms['linkEditForm'].contentItem_search.disabled = !status; \n//  document.forms['linkEditForm'].contentItem_clear.disabled = !status; \n//  document.forms['linkEditForm'].itemParams.disabled = !status; \n}\nfunction enableUrlFields() { \n  document.forms['linkEditForm'].targetURI.disabled = false; \n  document.forms['linkEditForm'].openOption.disabled = false; \n  document.forms['linkEditForm'].contentItem.disabled = true; \n  document.forms['linkEditForm'].contentItem_search.disabled = true; \n  //document.forms['linkEditForm'].contentItem_clear.disabled = true; \n  document.forms['linkEditForm'].itemParams.disabled = true; \n} \nfunction enableItemFields() { \n  document.forms['linkEditForm'].targetURI.disabled = true; \n  document.forms['linkEditForm'].openOption.disabled = true; \n  document.forms['linkEditForm'].contentItem.disabled = false; \n  document.forms['linkEditForm'].contentItem_search.disabled = false; \n  //document.forms['linkEditForm'].contentItem_clear.disabled = false; \n  document.forms['linkEditForm'].itemParams.disabled = false; \n} \n// -->\n</script>\n", false));
        this.add((Component)new Label("Choose either a URL or a Content Item", "b"), 64);
        this.m_linkType = new RadioGroup("linkType");
        Option m_external = new Option("externalLink", "URL");
        m_external.setOnClick("enableUrlFields()");
        Option m_internal = new Option("internalLink", "Content Item");
        m_internal.setOnClick("enableItemFields()");
        Option m_selectWindow = new Option("targetWindow", "Open URL in new window");
        this.m_URIOption = new CheckboxGroup("openOption");
        this.m_URIOption.addOption(m_selectWindow);
        this.m_linkType.addOption(m_external);
        this.m_linkType.addOption(m_internal);
        this.m_linkType.setOptionSelected(m_external);
        this.m_linkType.addValidationListener((ParameterListener)new NotNullValidationListener());
        this.add((Component)new Label("Link Type (Choose one):"));
        this.add((Component)this.m_linkType);
        this.add((Component)this.m_URIOption, 64);
        this.m_targetURI = new TextField("targetURI");
        this.m_targetURI.setOnFocus("toggle_link_fields(false)");
        this.m_targetURI.setHint("Enter a URL such as http://www.example.com/ or /ccm/forum/");
        this.add((Component)new Label("URL: "));
        this.add((Component)this.m_targetURI);
        this.add((Component)new Label("Content Item:"));
        this.m_itemSearch = new ItemSearchWidget("contentItem", this.m_contentType);
        this.m_itemSearch.getSearchButton().setOnFocus("toggle_link_fields(true)");
        this.m_itemSearch.getClearButton().setOnFocus("toggle_link_fields(true)");
        this.add((Component)this.m_itemSearch);
        this.add((Component)new Label("Parameters"));
        this.m_itemParams = new TextField("itemParams");
        this.m_itemParams.setOnFocus("toggle_link_fields(true)");
        this.m_itemParams.setHint("Enter parameters for the item URL. Separate items with '&'.");
        this.add((Component)this.m_itemParams);
        this.add((Component)new Label("<script language=\"javascript\">\n<!-- \nif (document.forms['linkEditForm'].linkType[0].checked) { \n  //toggle_link_fields(false); \n  enableUrlFields(); \n} else { \n  //toggle_link_fields(true); \n enableItemFields(); \n} \n// -->\n</script>\n", false));
    }

    public void addSaveCancelSection() {
        this.m_saveCancelSection = new SaveCancelSection();
        try {
            this.m_saveCancelSection.getCancelButton().addPrintListener(new PrintListener(){

                public void prepare(PrintEvent e) {
                    Submit target = (Submit)e.getTarget();
                    if (LinkPropertyForm.this.m_linkModel.isSelected(e.getPageState())) {
                        target.setButtonLabel("Cancel");
                    } else {
                        target.setButtonLabel("Reset");
                    }
                }
            });
            this.m_saveCancelSection.getSaveButton().addPrintListener(new PrintListener(){

                public void prepare(PrintEvent e) {
                    Submit target = (Submit)e.getTarget();
                    if (LinkPropertyForm.this.m_linkModel.isSelected(e.getPageState())) {
                        target.setButtonLabel("Save");
                    } else {
                        target.setButtonLabel("Create");
                    }
                }
            });
        }
        catch (TooManyListenersException e) {
            throw new UncheckedWrapperException("this cannot happen", (Throwable)e);
        }
        this.add((Component)this.m_saveCancelSection, 64);
    }

    public SaveCancelSection getSaveCancelSection() {
        return this.m_saveCancelSection;
    }

    protected LinkSelectionModel getLinkSelectionModel() {
        return this.m_linkModel;
    }

    public void submitted(FormSectionEvent e) throws FormProcessException {
        if (this.m_saveCancelSection.getCancelButton().isSelected(e.getPageState())) {
            s_log.debug((Object)"cancel in submission listener");
            this.m_linkModel.clearSelection(e.getPageState());
            this.init(e);
            throw new FormProcessException("cancelled");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void validate(FormSectionEvent event) throws FormProcessException {
        PageState state = event.getPageState();
        FormData data = event.getFormData();
        if ("externalLink".equals((String)this.m_linkType.getValue(state))) {
            String externalURI = (String)this.m_targetURI.getValue(state);
            if (externalURI == null || externalURI.length() == 0) {
                throw new FormProcessException("The URI field is required for an external link.");
            }
            String url = (String)this.m_targetURI.getValue(state);
            try {
                URL test = new URL(url);
                return;
            }
            catch (MalformedURLException ex) {
                String newURL;
                boolean hasProtocol;
                boolean localLink = url.startsWith("/");
                boolean bl = hasProtocol = url.indexOf("://") != -1;
                if (localLink) {
                    newURL = HTTP_PROTOCOL + Web.getConfig().getHost() + url;
                } else {
                    if (hasProtocol) throw new FormProcessException("URL is not valid: " + ex.getMessage());
                    newURL = HTTP_PROTOCOL + url;
                }
                try {
                    URL test = new URL(newURL);
                }
                catch (MalformedURLException ex2) {
                    StringBuffer msg = new StringBuffer();
                    if (localLink) {
                        msg.append("Local URL is not valid: ");
                        msg.append(ex2.getMessage());
                        throw new FormProcessException(msg.toString());
                    } else {
                        msg.append("External URL is not valid: ");
                        msg.append(ex.getMessage());
                    }
                    throw new FormProcessException(msg.toString());
                }
                if (localLink || hasProtocol) return;
                this.m_targetURI.setValue(state, (Object)newURL);
                throw new FormProcessException("A valid URL starts with a protocol, eg http://");
            }
        }
        if (!"internalLink".equals((String)this.m_linkType.getValue(state))) return;
        if (data.get((Object)"contentItem") == null) {
            throw new FormProcessException("Item selection is required for internal link.");
        }
        if (!this.m_itemModel.getSelectedItem(state).getID().equals(((ContentItem)data.get((Object)"contentItem")).getID())) return;
        throw new FormProcessException("Link target is the same as this object.");
    }

    protected ContentItem getContentItem(PageState s) {
        return (ContentItem)this.m_itemModel.getSelectedObject(s);
    }

    protected Link createLink(PageState s) {
        ContentItem item = this.getContentItem(s);
        Assert.exists((Object)item);
        Link link = new Link();
        return link;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void init(FormSectionEvent fse) throws FormProcessException {
        FormData data = fse.getFormData();
        PageState state = fse.getPageState();
        s_log.debug((Object)"Init");
        this.setVisible(state, true);
        if (this.m_linkModel.isSelected(state)) {
            s_log.debug((Object)"Edit");
            Link link = this.m_linkModel.getSelectedLink(state);
            try {
                this.m_title.setValue(state, (Object)link.getTitle());
                this.m_description.setValue(state, (Object)link.getDescription());
                if (link.getTargetURI() != null && link.getTargetURI().startsWith("&")) {
                    this.m_itemParams.setValue(state, (Object)link.getTargetURI().substring(1));
                } else {
                    this.m_targetURI.setValue(state, (Object)link.getTargetURI());
                }
                if ("_blank".equals(link.getTargetWindow())) {
                    this.m_URIOption.setValue(state, (Object)"targetWindow");
                } else {
                    this.m_URIOption.setValue(state, null);
                }
                this.m_linkType.setValue(state, (Object)link.getTargetType());
                if (!"internalLink".equals(link.getTargetType())) return;
                data.put((Object)"contentItem", (Object)link.getTargetItem());
                return;
            }
            catch (IllegalStateException e) {
                s_log.error((Object)e.getMessage());
                throw e;
            }
        } else {
            s_log.debug((Object)"new link");
            this.m_title.setValue(state, null);
            this.m_description.setValue(state, null);
            this.m_targetURI.setValue(state, null);
            this.m_URIOption.setValue(state, null);
            this.m_linkType.setValue(state, (Object)"externalLink");
            data.put((Object)"contentItem", null);
        }
    }

    public void process(FormSectionEvent fse) throws FormProcessException {
        PageState state = fse.getPageState();
        if (this.getSaveCancelSection().getCancelButton().isSelected(state)) {
            this.m_linkModel.clearSelection(state);
            s_log.debug((Object)"link save canceled");
        } else {
            Link link;
            if (this.m_linkModel.isSelected(state)) {
                s_log.debug((Object)"processing link edit");
                link = this.m_linkModel.getSelectedLink(state);
            } else {
                s_log.debug((Object)"processing new link");
                link = this.createLink(state);
            }
            this.setLinkProperties(link, fse);
            s_log.debug((Object)("Created Link with ID: " + link.getOID().toString() + "Title " + link.getTitle()));
        }
        this.m_linkModel.clearSelection(state);
        this.init(fse);
    }

    protected void setLinkProperties(Link link, FormSectionEvent fse) {
        PageState state = fse.getPageState();
        FormData data = fse.getFormData();
        link.setTitle((String)this.m_title.getValue(state));
        link.setDescription((String)this.m_description.getValue(state));
        link.setTargetType((String)this.m_linkType.getValue(state));
        if ("externalLink".equals(this.m_linkType.getValue(state))) {
            link.setTargetURI((String)this.m_targetURI.getValue(state));
            link.setTargetItem(null);
        } else {
            if (((String)this.m_itemParams.getValue(state)).isEmpty()) {
                link.setTargetURI(null);
            } else {
                link.setTargetURI(String.format("&%s", this.m_itemParams.getValue(state)));
            }
            ContentItem ci = (ContentItem)data.get((Object)"contentItem");
            if (ci.getParent() instanceof ContentBundle) {
                ci = (ContentItem)ci.getParent();
            }
            link.setTargetItem(ci);
        }
        boolean isNewWindow = false;
        String[] value = (String[])this.m_URIOption.getValue(state);
        if (value != null) {
            isNewWindow = "targetWindow".equals(value[0]);
        }
        if (isNewWindow) {
            link.setTargetWindow("_blank");
        } else {
            link.setTargetWindow("");
        }
        link.save();
    }
}

