/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.ExternalLink;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.event.TableActionEvent;
import com.arsdigita.bebop.event.TableActionListener;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.table.TableColumn;
import com.arsdigita.bebop.table.TableColumnModel;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.SecurityManager;
import com.arsdigita.cms.contenttypes.Link;
import com.arsdigita.cms.contenttypes.ui.LinkSelectionModel;
import com.arsdigita.cms.contenttypes.ui.LinkTableModelBuilder;
import com.arsdigita.cms.dispatcher.Utilities;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.PersistenceException;
import com.arsdigita.util.Assert;
import com.arsdigita.util.UncheckedWrapperException;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class LinkTable
extends Table {
    private static final Logger s_log = Logger.getLogger(LinkTable.class);
    private LinkSelectionModel m_linkModel;
    private ItemSelectionModel m_itemModel;
    private TableColumn m_titleCol;
    private TableColumn m_descCol;
    private TableColumn m_moveUpCol;
    private TableColumn m_moveDownCol;
    private TableColumn m_editCol;
    private TableColumn m_delCol;
    private RequestLocal m_size;
    private RequestLocal m_editor;
    protected static final String EDIT_EVENT = "Edit";
    protected static final String DELETE_EVENT = "Delete";
    protected static final String UP_EVENT = "up";
    protected static final String DOWN_EVENT = "down";

    public LinkTable(ItemSelectionModel item, LinkSelectionModel link) {
        this.m_itemModel = item;
        this.m_linkModel = link;
        this.addColumns();
        this.m_size = new RequestLocal();
        this.m_editor = new RequestLocal(){

            public Object initialValue(PageState state) {
                SecurityManager sm = Utilities.getSecurityManager(state);
                ContentItem item = (ContentItem)LinkTable.this.m_itemModel.getSelectedObject(state);
                Boolean val = new Boolean(sm.canAccess(state.getRequest(), "edit_item", item));
                return val;
            }
        };
        Label empty = new Label("There are no links for this content item");
        this.setEmptyView((Component)empty);
        this.addTableActionListener(new LinkTableActionListener());
        this.setRowSelectionModel((SingleSelectionModel)this.m_linkModel);
        this.setDefaultCellRenderer(new LinkTableRenderer());
    }

    protected void addColumns() {
        TableColumnModel model = this.getColumnModel();
        int i = 0;
        this.m_titleCol = new TableColumn(i, (Object)"Link");
        this.m_descCol = new TableColumn(++i, (Object)"Description");
        this.m_editCol = new TableColumn(++i, (Object)EDIT_EVENT);
        this.m_delCol = new TableColumn(++i, (Object)DELETE_EVENT);
        this.m_moveUpCol = new TableColumn(++i, (Object)"");
        this.m_moveDownCol = new TableColumn(++i, (Object)"");
        model.add(this.m_titleCol);
        model.add(this.m_descCol);
        model.add(this.m_editCol);
        model.add(this.m_delCol);
        model.add(this.m_moveUpCol);
        model.add(this.m_moveDownCol);
        this.setColumnModel(model);
    }

    private class LinkTableActionListener
    implements TableActionListener {
        private LinkTableActionListener() {
        }

        private Link getLink(TableActionEvent e) {
            Link link;
            BigDecimal id;
            Object o = e.getRowKey();
            if (o instanceof String) {
                s_log.debug((Object)("row key is a string : " + o));
                id = new BigDecimal((String)o);
            } else {
                id = (BigDecimal)e.getRowKey();
            }
            Assert.exists((Object)id);
            try {
                link = (Link)DomainObjectFactory.newInstance((OID)new OID("com.arsdigita.cms.contenttypes.Link", (Object)id));
            }
            catch (DataObjectNotFoundException de) {
                throw new UncheckedWrapperException((Throwable)de);
            }
            return link;
        }

        public void cellSelected(TableActionEvent e) {
            int col = e.getColumn();
            PageState state = e.getPageState();
            Link link = this.getLink(e);
            Assert.exists((Object)((Object)link));
            if (col != LinkTable.this.m_titleCol.getModelIndex()) {
                if (col == LinkTable.this.m_editCol.getModelIndex()) {
                    if (Boolean.TRUE.equals(LinkTable.this.m_editor.get(state))) {
                        s_log.debug((Object)("setting linkModel to :" + link.getTitle()));
                        LinkTable.this.m_linkModel.setSelectedObject(state, (DomainObject)link);
                    }
                } else if (col == LinkTable.this.m_delCol.getModelIndex()) {
                    if (Boolean.TRUE.equals(LinkTable.this.m_editor.get(state))) {
                        try {
                            s_log.debug((Object)"About to delete");
                            LinkTable.this.m_linkModel.clearSelection(state);
                            link.delete();
                        }
                        catch (PersistenceException pe) {
                            throw new UncheckedWrapperException((Throwable)pe);
                        }
                    }
                } else if (col == LinkTable.this.m_moveUpCol.getModelIndex()) {
                    LinkTable.this.m_linkModel.clearSelection(state);
                    link.swapWithPrevious();
                } else if (col == LinkTable.this.m_moveDownCol.getModelIndex()) {
                    LinkTable.this.m_linkModel.clearSelection(state);
                    link.swapWithNext();
                }
            }
        }

        public void headSelected(TableActionEvent e) {
        }
    }

    private class LinkTableRenderer
    implements TableCellRenderer {
        private LinkTableRenderer() {
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            boolean isLast;
            boolean isFirst;
            Link link = (Link)((Object)value);
            boolean bl = isFirst = row == 0;
            if (LinkTable.this.m_size.get(state) == null) {
                LinkTable.this.m_size.set(state, (Object)new Long(((LinkTableModelBuilder.LinkTableModel)table.getTableModel(state)).size()));
            }
            boolean bl2 = isLast = row == ((Long)LinkTable.this.m_size.get(state)).intValue() - 1;
            if (column == LinkTable.this.m_titleCol.getModelIndex()) {
                String url = link.getInternalOrExternalURI(state);
                ExternalLink extLink = new ExternalLink(link.getTitle(), url);
                extLink.setTargetFrame("_blank");
                return extLink;
            }
            if (column == LinkTable.this.m_descCol.getModelIndex()) {
                if (isSelected) {
                    return new Label(link.getDescription(), "b");
                }
                return new Label(link.getDescription());
            }
            if (column == LinkTable.this.m_editCol.getModelIndex()) {
                if (Boolean.TRUE.equals(LinkTable.this.m_editor.get(state))) {
                    if (isSelected) {
                        return new Label(LinkTable.EDIT_EVENT, "b");
                    }
                    return new ControlLink(LinkTable.EDIT_EVENT);
                }
                return new Label(LinkTable.EDIT_EVENT);
            }
            if (column == LinkTable.this.m_delCol.getModelIndex()) {
                if (Boolean.TRUE.equals(LinkTable.this.m_editor.get(state))) {
                    return new ControlLink(LinkTable.DELETE_EVENT);
                }
                return new Label(LinkTable.DELETE_EVENT);
            }
            if (column == LinkTable.this.m_moveUpCol.getModelIndex()) {
                if (Boolean.TRUE.equals(LinkTable.this.m_editor.get(state)) && !isFirst) {
                    Label upLabel = new Label(LinkTable.UP_EVENT);
                    upLabel.setClassAttr("linkSort");
                    return new ControlLink((Component)upLabel);
                }
                return new Label("");
            }
            if (column == LinkTable.this.m_moveDownCol.getModelIndex()) {
                if (Boolean.TRUE.equals(LinkTable.this.m_editor.get(state)) && !isLast) {
                    Label downLabel = new Label(LinkTable.DOWN_EVENT);
                    downLabel.setClassAttr("linkSort");
                    return new ControlLink((Component)downLabel);
                }
                return new Label("");
            }
            throw new UncheckedWrapperException("column out of bounds");
        }
    }
}

