/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.cms.contenttypes.Link;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.util.LockableImpl;
import org.apache.log4j.Logger;

public abstract class LinkTableModelBuilder
extends LockableImpl
implements TableModelBuilder {
    private static final Logger s_log = Logger.getLogger(LinkTableModelBuilder.class);

    public TableModel makeModel(Table t, PageState s) {
        s_log.debug((Object)"LinkTableModelBuilder.makemodel");
        DataCollection links = this.getLinks(s);
        if (links.isEmpty()) {
            return Table.EMPTY_MODEL;
        }
        return new LinkTableModel(links);
    }

    public abstract DataCollection getLinks(PageState var1);

    public static class LinkTableModel
    implements TableModel {
        Link m_link;
        DataCollection m_links;

        public LinkTableModel(DataCollection links) {
            this.m_links = links;
            this.m_link = null;
        }

        public boolean nextRow() {
            s_log.debug((Object)String.format("m_links.size() = %d", this.m_links.size()));
            if (this.m_links.next()) {
                s_log.debug((Object)"Getting domain object for link...");
                long now = System.currentTimeMillis();
                DataObject object = this.m_links.getDataObject();
                this.m_link = (Link)DomainObjectFactory.newInstance((DataObject)object);
                s_log.debug((Object)String.format("Got domain object in %d ms", System.currentTimeMillis() - now));
                return true;
            }
            return false;
        }

        public int getColumnCount() {
            return (int)this.m_links.size();
        }

        public Object getElementAt(int columnIndex) {
            return this.m_link;
        }

        public Object getKeyAt(int columnIndex) {
            return this.m_link.getID();
        }

        public long size() {
            return this.m_links.size();
        }
    }
}

