/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui.panels;

import com.arsdigita.cms.contenttypes.ui.panels.Filter;
import com.arsdigita.xml.Element;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public class CompareFilter
implements Filter {
    public static final String ALL = "--ALL--";
    public static final String NONE = "--NONE--";
    private final String property;
    private final String label;
    private final boolean allOption;
    private final boolean allOptionIsDefault;
    private final boolean propertyIsNumeric;
    private boolean emptyDefaultOption = false;
    private Map<String, Option> options = new LinkedHashMap<String, Option>();
    private String value;

    public CompareFilter(String label, String property, boolean allOption, boolean allOptionIsDefault, boolean propertyIsNumeric) {
        this.property = property;
        this.label = label;
        this.allOption = allOption;
        this.allOptionIsDefault = allOptionIsDefault;
        this.propertyIsNumeric = propertyIsNumeric;
    }

    public CompareFilter(String label, String property, boolean allOption, boolean allOptionIsDefault, boolean propertyIsNumeric, boolean emptyDefaultOption) {
        this(label, property, allOption, allOptionIsDefault, propertyIsNumeric);
        this.emptyDefaultOption = true;
    }

    @Override
    public String getProperty() {
        return this.property;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public CompareFilter addOption(String label, String value) {
        return this.addOption(label, Operators.EQ, value, false);
    }

    public CompareFilter addOption(String label, Operators operator, String value, boolean includeNull) {
        Option option = new Option(label, operator, value, includeNull);
        this.options.put(label, option);
        return this;
    }

    @Override
    public String getFilter() {
        if (this.value == null || this.value.isEmpty()) {
            if (this.allOptionIsDefault) {
                this.value = ALL;
            } else {
                if (this.emptyDefaultOption) {
                    return "";
                }
                this.value = new ArrayList<Option>(this.options.values()).get(0).getLabel();
            }
        }
        if (ALL.equals(this.value) || NONE.equals(this.value)) {
            return "";
        }
        Option selectedOption = this.options.get(this.value);
        if (selectedOption == null) {
            throw new IllegalArgumentException(String.format("Unknown option '%s' selected for CompareFilter for property '%s'.", this.value, this.property));
        }
        StringBuffer filter = new StringBuffer();
        filter.append(this.property);
        switch (selectedOption.getOperator()) {
            case EQ: {
                filter.append(" = ");
                break;
            }
            case LT: {
                filter.append(" < ");
                break;
            }
            case GT: {
                filter.append(" > ");
                break;
            }
            case LTEQ: {
                filter.append(" <= ");
                break;
            }
            case GTEQ: {
                filter.append(" >= ");
            }
        }
        if (this.propertyIsNumeric) {
            filter.append(selectedOption.getValue());
        } else {
            filter.append('\'');
            filter.append(selectedOption.getValue());
            filter.append('\'');
        }
        if (selectedOption.getIncludeNull()) {
            filter.append(String.format(" or %s is null", this.property));
        }
        return filter.toString();
    }

    public String getValue() {
        return this.value;
    }

    public Operators getOperator() {
        return this.options.get(this.value).getOperator();
    }

    @Override
    public void generateXml(Element parent) {
        Element option;
        String selected;
        Element filter = parent.newChildElement("filter");
        filter.addAttribute("type", "compare");
        if (this.value == null || this.value.isEmpty()) {
            if (this.allOptionIsDefault) {
                selected = ALL;
            } else if (this.emptyDefaultOption) {
                selected = NONE;
            } else {
                ArrayList<Option> optionsList = new ArrayList<Option>(this.options.values());
                selected = ((Option)optionsList.get(0)).getLabel();
            }
        } else {
            selected = this.value;
        }
        filter.addAttribute("label", this.label);
        filter.addAttribute("selected", selected);
        if (this.allOption) {
            option = filter.newChildElement("option");
            option.addAttribute("label", ALL);
        }
        if (this.emptyDefaultOption) {
            Element emptyOption = filter.newChildElement("option");
            emptyOption.addAttribute("label", NONE);
        }
        for (Map.Entry<String, Option> entry : this.options.entrySet()) {
            option = filter.newChildElement("option");
            option.addAttribute("label", entry.getValue().getLabel());
        }
    }

    @Override
    public void setValue(String value) {
        this.value = value;
    }

    public static class Option {
        private final String label;
        private final Operators operator;
        private final String value;
        private final boolean includeNull;

        public Option(String label, Operators operator, String value, boolean includeNull) {
            this.label = label;
            this.operator = operator;
            this.value = value;
            this.includeNull = includeNull;
        }

        public String getLabel() {
            return this.label;
        }

        public Operators getOperator() {
            return this.operator;
        }

        public String getValue() {
            return this.value;
        }

        public boolean getIncludeNull() {
            return this.includeNull;
        }
    }

    public static enum Operators {
        EQ,
        LT,
        GT,
        LTEQ,
        GTEQ;

    }
}

