/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui.panels;

import com.arsdigita.persistence.DataQuery;
import com.arsdigita.web.ParameterMap;
import com.arsdigita.web.URL;
import com.arsdigita.web.Web;
import com.arsdigita.xml.Element;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class Paginator {
    private static final String PAGE_NUMBER = "pageNumber";
    private static final String PAGE_SIZE = "pageSize";
    private final int pageSize;
    private int pageNumber;
    private final int objectCount;
    private final Logger logger = Logger.getLogger(Paginator.class);

    public Paginator(HttpServletRequest request, int objectCount) {
        this(request, objectCount, 30);
    }

    public Paginator(HttpServletRequest request, int objectCount, int pageSize) {
        String pageNumberStr = request.getParameter(PAGE_NUMBER);
        if (pageNumberStr == null) {
            this.logger.debug((Object)"No pageNumber parameter in request setting page number to 1.");
            this.pageNumber = 1;
        } else {
            this.pageNumber = Integer.parseInt(pageNumberStr);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)String.format("pageNumber = %d", this.pageNumber));
        }
        this.objectCount = objectCount;
        if (request.getParameter(PAGE_SIZE) == null) {
            this.pageSize = pageSize;
        } else {
            String pageSizeStr = request.getParameter(PAGE_SIZE);
            this.pageSize = Integer.parseInt(pageSizeStr);
        }
        this.normalizePageNumber();
    }

    public void generateXml(Element parent) {
        Element paginatorElem = parent.newChildElement("nav:paginator", "http://ccm.redhat.com/navigation");
        URL requestUrl = Web.getContext().getRequestURL();
        ParameterMap parameters = new ParameterMap();
        if (requestUrl.getParameterMap() != null) {
            Iterator current = requestUrl.getParameterMap().keySet().iterator();
            while (current.hasNext()) {
                this.copyParameter(requestUrl, (String)current.next(), parameters);
            }
        }
        paginatorElem.addAttribute("pageParam", PAGE_NUMBER);
        paginatorElem.addAttribute("baseURL", URL.there((String)requestUrl.getPathInfo(), (ParameterMap)parameters).toString());
        paginatorElem.addAttribute(PAGE_NUMBER, Integer.toString(this.pageNumber));
        paginatorElem.addAttribute("pageCount", Integer.toString(this.getPageCount()));
        paginatorElem.addAttribute(PAGE_SIZE, Integer.toString(this.pageSize));
        paginatorElem.addAttribute("objectBegin", Integer.toString(this.getBegin()));
        paginatorElem.addAttribute("objectEnd", Integer.toString(this.getEnd()));
        paginatorElem.addAttribute("objectCount", Integer.toString(this.objectCount));
    }

    public void applyLimits(DataQuery query) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Paginator values: ");
            this.logger.debug((Object)String.format(" objectCount = %d", this.objectCount));
            this.logger.debug((Object)String.format("    begin    = %d", this.getBegin()));
            this.logger.debug((Object)String.format("      end    = %d", this.getEnd()));
            this.logger.debug((Object)String.format("pageCount    = %d", this.getPageCount()));
            this.logger.debug((Object)String.format("    count    = %d", this.getCount()));
        }
        this.logger.debug((Object)String.format("Applying limits: %d, %d", this.getBegin(), this.getEnd()));
        query.setRange(Integer.valueOf(this.getBegin()), Integer.valueOf(this.getEnd() + 1));
    }

    public <T> List<T> applyListLimits(List<T> list, Class<T> type) {
        int end;
        int begin = this.getBegin() - 1;
        if (begin < 0) {
            begin = 0;
        }
        if ((end = this.getEnd()) >= list.size()) {
            end = list.size();
        }
        return list.subList(begin, end);
    }

    public int getPageCount() {
        return (int)Math.ceil((double)this.objectCount / (double)this.pageSize);
    }

    private int normalizePageNumber() {
        int pageCount = this.getPageCount();
        int num = this.pageNumber;
        if (num < 1) {
            num = 1;
        }
        if (num > pageCount) {
            num = pageCount == 0 ? 1 : pageCount;
        }
        return num;
    }

    public int getBegin() {
        if (this.pageNumber == 1) {
            return 1;
        }
        return (this.pageNumber - 1) * this.pageSize + 1;
    }

    public int getCount() {
        return Math.min(this.pageSize, this.objectCount - this.getBegin() + 1);
    }

    public int getEnd() {
        int paginatorEnd = this.getBegin() + this.getCount() - 1;
        if (paginatorEnd < 0) {
            paginatorEnd = 0;
        }
        if (paginatorEnd <= this.getBegin()) {
            paginatorEnd = this.getBegin() + 1;
        }
        return paginatorEnd;
    }

    private void copyParameter(URL requestUrl, String key, ParameterMap parameters) {
        if (PAGE_NUMBER.equals(key)) {
            return;
        }
        parameters.setParameterValues(key, requestUrl.getParameterValues(key));
    }
}

