/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui.panels;

import com.arsdigita.cms.contenttypes.ui.panels.Filter;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.xml.Element;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class SelectFilter
implements Filter {
    public static final String NONE = "--NONE--";
    public static final String ALL = "--ALL--";
    private final String property;
    private final String label;
    private DataQuery dataQuery;
    private String queryProperty;
    private final boolean allOption;
    private final boolean allOptionIsDefault;
    private final boolean reverseOptions;
    private final boolean propertyIsNumeric;
    private boolean emptyDefaultOption = false;
    private String value;

    public SelectFilter(String label, String property, boolean reverseOptions, boolean allOption, boolean allOptionIsDefault, boolean propertyIsNumeric) {
        this.property = property;
        this.label = label;
        this.reverseOptions = reverseOptions;
        this.allOption = allOption;
        this.allOptionIsDefault = allOptionIsDefault;
        this.propertyIsNumeric = propertyIsNumeric;
    }

    public SelectFilter(String label, String property, boolean reverseOptions, boolean allOption, boolean allOptionIsDefault, boolean propertyIsNumeric, boolean emptyDefaultOption) {
        this(label, property, reverseOptions, allOption, allOptionIsDefault, propertyIsNumeric);
        this.emptyDefaultOption = emptyDefaultOption;
    }

    @Override
    public String getProperty() {
        return this.property;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public void setDataQuery(DataQuery dataQuery, String queryProperty) {
        this.dataQuery = dataQuery;
        this.queryProperty = queryProperty;
    }

    @Override
    public String getFilter() {
        if (this.value == null || this.value.isEmpty()) {
            this.value = this.allOptionIsDefault ? ALL : (this.emptyDefaultOption ? NONE : this.getOptions().get(0));
        }
        if (ALL.equals(this.value) || NONE.equals(this.value)) {
            return null;
        }
        if (this.propertyIsNumeric) {
            return String.format("%s = %s", this.property, this.value);
        }
        return String.format("%s = '%s'", this.property, this.value);
    }

    @Override
    public void generateXml(Element parent) {
        Element optionElem;
        List<String> options = this.getOptions();
        Element filter = parent.newChildElement("filter");
        filter.addAttribute("type", "select");
        filter.addAttribute("label", this.label);
        if (options.isEmpty()) {
            return;
        }
        String selected = this.value == null || this.value.isEmpty() ? (this.allOptionIsDefault ? ALL : (this.emptyDefaultOption ? NONE : options.get(0))) : this.value;
        filter.addAttribute("selected", selected);
        if (this.emptyDefaultOption) {
            optionElem = filter.newChildElement("option");
            optionElem.addAttribute("label", NONE);
        }
        if (this.allOption) {
            optionElem = filter.newChildElement("option");
            optionElem.addAttribute("label", ALL);
        }
        for (String optionStr : options) {
            optionElem = filter.newChildElement("option");
            optionElem.addAttribute("label", optionStr);
            if (this.propertyIsNumeric) {
                optionElem.addAttribute("valueType", "number");
                continue;
            }
            optionElem.addAttribute("valueType", "text");
        }
    }

    @Override
    public void setValue(String value) {
        this.value = value;
    }

    private List<String> getOptions() {
        HashSet<String> optionsSet = new HashSet<String>();
        while (this.dataQuery.next()) {
            Object obj = this.dataQuery.get(this.queryProperty);
            if (obj == null) continue;
            String option = obj.toString();
            optionsSet.add(option);
        }
        this.dataQuery.rewind();
        ArrayList<String> options = new ArrayList<String>(optionsSet);
        Collections.sort(options);
        if (this.reverseOptions) {
            Collections.reverse(options);
        }
        return options;
    }
}

