/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui.panels;

import com.arsdigita.cms.contenttypes.ui.panels.Filter;
import com.arsdigita.xml.Element;

public class TextFilter
implements Filter {
    private final String property;
    private final String label;
    private String value;

    @Override
    public String getProperty() {
        return this.property;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public TextFilter(String label, String property) {
        this.property = property;
        this.label = label;
    }

    @Override
    public String getFilter() {
        if (this.value == null || this.value.isEmpty()) {
            return null;
        }
        return String.format("(lower(%s) LIKE lower('%%%s%%'))", this.property, this.value);
    }

    @Override
    public void generateXml(Element parent) {
        Element textFilter = parent.newChildElement("filter");
        textFilter.addAttribute("type", "text");
        textFilter.addAttribute("label", this.label);
        if (this.value != null && !this.value.isEmpty()) {
            textFilter.addAttribute("value", this.value);
        }
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        this.value = value;
    }
}

