/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.upgrades;

import com.arsdigita.runtime.RuntimeConfig;
import com.arsdigita.util.jdbc.Connections;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractAssocUpgrade {
    protected abstract String getTableName();

    protected abstract String getOwnerIdCol();

    protected abstract String getMemberIdCol();

    protected abstract Map<String, String> getAttributes();

    protected abstract String getPrimaryKeyConstraintName();

    protected abstract String getOwnerConstraintName();

    protected abstract String getMemberConstraintName();

    protected abstract String getOwnerTableName();

    protected abstract String getMemberTableName();

    protected void doUpgrade() {
        Statement stmt;
        System.out.println("Starting upgrade...");
        ArrayList<AssocEntry> oldData = new ArrayList<AssocEntry>();
        Connection conn = Connections.acquire((String)RuntimeConfig.getConfig().getJDBCURL());
        try {
            conn.setAutoCommit(false);
        }
        catch (SQLException ex) {
            System.err.println("Failed to configure JDBC connection.");
            this.printStackTrace(ex);
            this.close(conn);
            return;
        }
        System.out.println("Retrieving old data...");
        try {
            stmt = conn.createStatement();
            ResultSet oldAssocResult = stmt.executeQuery(String.format("SELECT * FROM %s JOIN cms_items on %s = item_id WHERE version = 'draft' ", this.getTableName(), this.getOwnerIdCol()));
            while (oldAssocResult.next()) {
                AssocEntry entry = new AssocEntry();
                entry.setOwnerDraftId(oldAssocResult.getBigDecimal(this.getOwnerIdCol()));
                entry.setOwnerDraftBundleId(this.getParentIdFor(entry.getOwnerDraftId(), conn));
                entry.setMemberDraftId(oldAssocResult.getBigDecimal(this.getMemberIdCol()));
                entry.setMemberDraftBundleId(this.getParentIdFor(entry.getMemberDraftId(), conn));
                entry.setOwnerPublicId(this.getPublicIdFor(entry.getOwnerDraftId(), conn));
                entry.setOwnerPublicBundleId(this.getPublicIdFor(entry.getOwnerDraftBundleId(), conn));
                entry.setMemberPublicId(this.getPublicIdFor(entry.getMemberDraftId(), conn));
                entry.setMemberPublicBundleId(this.getPublicIdFor(entry.getMemberDraftBundleId(), conn));
                for (Map.Entry<String, String> attribute : this.getAttributes().entrySet()) {
                    entry.addAttribute(attribute.getKey(), oldAssocResult.getString(attribute.getKey()));
                }
                oldData.add(entry);
            }
        }
        catch (SQLException ex) {
            System.err.println("Failed to retrieve old data.");
            this.printStackTrace(ex);
            return;
        }
        try {
            System.out.println("Droping old table...");
            stmt = conn.createStatement();
            stmt.execute(String.format("DROP TABLE %s", this.getTableName()));
        }
        catch (SQLException ex) {
            System.err.println("Failed to drop old table.");
            this.printStackTrace(ex);
            this.rollback(conn);
            this.close(conn);
            return;
        }
        try {
            System.out.printf("Creating new table %s...\n", this.getTableName());
            stmt = conn.createStatement();
            StringBuilder attributesBuilder = new StringBuilder();
            for (Map.Entry<String, String> attribute : this.getAttributes().entrySet()) {
                if (attributesBuilder.length() > 0) {
                    attributesBuilder.append(",\n");
                }
                attributesBuilder.append(attribute.getKey()).append(' ').append(attribute.getValue());
            }
            stmt.addBatch(String.format("CREATE TABLE %s (%s integer NOT NULL,%s integer NOT NULL,%s)", this.getTableName(), this.getOwnerIdCol(), this.getMemberIdCol(), attributesBuilder.toString()));
            stmt.addBatch(String.format("ALTER TABLE ONLY %s ADD CONSTRAINT %s PRIMARY KEY (%s, %s)", this.getTableName(), this.getPrimaryKeyConstraintName(), this.getOwnerIdCol(), this.getMemberIdCol()));
            stmt.addBatch(String.format("ALTER TABLE ONLY %s ADD CONSTRAINT %s FOREIGN KEY (%s)REFERENCES %s(bundle_id)", this.getTableName(), this.getOwnerConstraintName(), this.getOwnerIdCol(), this.getOwnerTableName()));
            stmt.addBatch(String.format("ALTER TABLE ONLY %s ADD CONSTRAINT %s FOREIGN KEY (%s)REFERENCES %s(bundle_id)", this.getTableName(), this.getMemberConstraintName(), this.getMemberIdCol(), this.getMemberTableName()));
            stmt.executeBatch();
        }
        catch (SQLException ex) {
            System.err.printf("Failed to create new table '%s'.\n", this.getTableName());
            this.printStackTrace(ex);
            this.rollback(conn);
            this.close(conn);
            return;
        }
        try {
            System.out.println("Filling new table with data...");
            ArrayList<String> processedEntries = new ArrayList<String>();
            Statement stmt2 = conn.createStatement();
            for (AssocEntry entry : oldData) {
                if (processedEntries.contains(String.format("%s-%s", entry.getOwnerDraftBundleId().toString(), entry.getMemberDraftBundleId().toString()))) continue;
                StringBuilder attributeCols = new StringBuilder();
                for (Map.Entry<String, String> attribute : this.getAttributes().entrySet()) {
                    attributeCols.append(",");
                    attributeCols.append(attribute.getKey());
                }
                StringBuilder attributeValues = new StringBuilder();
                for (Map.Entry<String, String> attribute : this.getAttributes().entrySet()) {
                    attributeValues.append(",");
                    if (attribute.getValue().startsWith("character") || attribute.getValue().startsWith("BIT") || attribute.getValue().startsWith("boolean")) {
                        attributeValues.append('\'');
                    }
                    attributeValues.append(entry.getAttributes().get(attribute.getKey()));
                    if (!attribute.getValue().startsWith("character") && !attribute.getValue().startsWith("BIT") && !attribute.getValue().startsWith("boolean")) continue;
                    attributeValues.append('\'');
                }
                stmt2.addBatch(String.format("INSERT INTO %s (%s,%s%s) VALUES (%s, %s %s)", this.getTableName(), this.getOwnerIdCol(), this.getMemberIdCol(), attributeCols.toString(), entry.getOwnerDraftBundleId().toString(), entry.getMemberDraftBundleId().toString(), attributeValues.toString()));
                if (entry.getOwnerPublicBundleId() != null && entry.getMemberPublicBundleId() != null) {
                    stmt2.addBatch(String.format("INSERT INTO %s (%s,%s%s) VALUES (%s, %s %s)", this.getTableName(), this.getOwnerIdCol(), this.getMemberIdCol(), attributeCols.toString(), entry.getOwnerPublicBundleId().toString(), entry.getMemberPublicBundleId().toString(), attributeValues.toString()));
                }
                if (entry.getOwnerPublicId() != null) {
                    stmt2.addBatch(String.format("DELETE FROM cms_published_links WHERE pending = %s AND draft_target = %s", entry.getOwnerPublicId().toString(), entry.getMemberDraftId().toString()));
                }
                if (entry.getMemberPublicId() != null) {
                    stmt2.addBatch(String.format("DELETE FROM cms_published_links WHERE pending = %sAND draft_target = %s", entry.getMemberPublicId().toString(), entry.getOwnerDraftId().toString()));
                }
                processedEntries.add(String.format("%s-%s", entry.getOwnerDraftBundleId().toString(), entry.getMemberDraftBundleId().toString()));
                stmt2.executeBatch();
            }
        }
        catch (SQLException ex) {
            System.err.println("Failed to fill table.");
            this.printStackTrace(ex);
            this.rollback(conn);
            this.close(conn);
            return;
        }
        try {
            conn.commit();
        }
        catch (SQLException ex) {
            System.err.println("Failed to commiting changes.");
            this.printStackTrace(ex);
            this.rollback(conn);
            return;
        }
        this.close(conn);
    }

    private BigDecimal getPublicIdFor(BigDecimal id, Connection conn) throws SQLException {
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery(String.format("SELECT item_id FROM cms_items WHERE master_id = %s", id.toString()));
        if (rs.next()) {
            return rs.getBigDecimal(1);
        }
        return null;
    }

    private BigDecimal getParentIdFor(BigDecimal id, Connection conn) throws SQLException {
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery(String.format("SELECT parent_id FROM cms_items WHERE item_id = %s", id.toString()));
        if (rs.next()) {
            return rs.getBigDecimal(1);
        }
        return null;
    }

    private void rollback(Connection conn) {
        try {
            conn.rollback();
        }
        catch (SQLException ex1) {
            System.err.println("Rollback failed.");
            ex1.printStackTrace(System.err);
        }
    }

    private void close(Connection conn) {
        try {
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("Failed to close JDBC connection.");
            this.printStackTrace(ex);
        }
    }

    private void printStackTrace(SQLException ex) {
        ex.printStackTrace(System.err);
        if (ex.getNextException() != null) {
            this.printStackTrace(ex.getNextException());
        }
    }

    private class AssocEntry {
        private BigDecimal ownerDraftId;
        private BigDecimal memberDraftId;
        private BigDecimal ownerPublicId;
        private BigDecimal memberPublicId;
        private BigDecimal ownerDraftBundleId;
        private BigDecimal memberDraftBundleId;
        private BigDecimal ownerPublicBundleId;
        private BigDecimal memberPublicBundleId;
        private Map<String, String> attributes = new HashMap<String, String>();

        public BigDecimal getOwnerDraftId() {
            return this.ownerDraftId;
        }

        public void setOwnerDraftId(BigDecimal ownerDraftId) {
            this.ownerDraftId = ownerDraftId;
        }

        public BigDecimal getMemberDraftId() {
            return this.memberDraftId;
        }

        public void setMemberDraftId(BigDecimal memberDraftId) {
            this.memberDraftId = memberDraftId;
        }

        public BigDecimal getOwnerPublicId() {
            return this.ownerPublicId;
        }

        public void setOwnerPublicId(BigDecimal ownerPublicId) {
            this.ownerPublicId = ownerPublicId;
        }

        public BigDecimal getMemberPublicId() {
            return this.memberPublicId;
        }

        public void setMemberPublicId(BigDecimal memberPublicId) {
            this.memberPublicId = memberPublicId;
        }

        public BigDecimal getOwnerDraftBundleId() {
            return this.ownerDraftBundleId;
        }

        public void setOwnerDraftBundleId(BigDecimal ownerDraftBundleId) {
            this.ownerDraftBundleId = ownerDraftBundleId;
        }

        public BigDecimal getMemberDraftBundleId() {
            return this.memberDraftBundleId;
        }

        public void setMemberDraftBundleId(BigDecimal memberDraftBundleId) {
            this.memberDraftBundleId = memberDraftBundleId;
        }

        public BigDecimal getMemberPublicBundleId() {
            return this.memberPublicBundleId;
        }

        public void setMemberPublicBundleId(BigDecimal memberPublicBundleId) {
            this.memberPublicBundleId = memberPublicBundleId;
        }

        public BigDecimal getOwnerPublicBundleId() {
            return this.ownerPublicBundleId;
        }

        public void setOwnerPublicBundleId(BigDecimal ownerPublicBundleId) {
            this.ownerPublicBundleId = ownerPublicBundleId;
        }

        public Map<String, String> getAttributes() {
            return Collections.unmodifiableMap(this.attributes);
        }

        public void addAttribute(String name, String value) {
            this.attributes.put(name, value);
        }

        public void setAttributes(Map<String, String> attributes) {
            this.attributes = attributes;
        }
    }
}

