/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.upgrades;

import com.arsdigita.runtime.RuntimeConfig;
import com.arsdigita.util.jdbc.Connections;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public abstract class AbstractBundleUpgrade {
    protected abstract String getBundleTableName();

    protected abstract String getContentItemTableName();

    protected abstract String getIdColName();

    protected abstract String getBundleClassName();

    protected abstract String getPrimaryKeyConstraintName();

    protected abstract String getBundleContraintName();

    protected String getSuperBundleTable() {
        return "cms_bundles";
    }

    public void doUpgrade() {
        System.out.println("Starting upgrade...");
        System.out.println("Trying to get JDBC connection...");
        Connection conn = Connections.acquire((String)RuntimeConfig.getConfig().getJDBCURL());
        try {
            conn.setAutoCommit(false);
        }
        catch (SQLException ex) {
            System.err.println("Failed to configure JDBC connection.");
            this.printStackTrace(ex);
            this.close(conn);
            return;
        }
        try {
            System.out.printf("Creating new table %s...\n", this.getBundleTableName());
            Statement stmt = conn.createStatement();
            stmt.addBatch(String.format("CREATE TABLE %s ( bundle_id integer NOT NULL);", this.getBundleTableName()));
            stmt.addBatch(String.format("ALTER TABLE ONLY %s ADD CONSTRAINT %s PRIMARY KEY (bundle_id);", this.getBundleTableName(), this.getPrimaryKeyConstraintName()));
            stmt.addBatch(String.format("ALTER TABLE ONLY %s ADD CONSTRAINT %s FOREIGN KEY (bundle_id) REFERENCES %s(bundle_id);", this.getBundleTableName(), this.getBundleContraintName(), this.getSuperBundleTable()));
            stmt.executeBatch();
        }
        catch (SQLException ex) {
            System.err.printf("Failed to create table %s.\n", this.getBundleTableName());
            this.printStackTrace(ex);
            this.rollback(conn);
            this.close(conn);
            return;
        }
        try {
            System.out.println("Filling new tables with data...");
            Statement queryPersonsStmt = conn.createStatement();
            Statement stmt = conn.createStatement();
            ResultSet personsRs = queryPersonsStmt.executeQuery(String.format("SELECT parent_id FROM cms_items JOIN %s ON cms_items.item_id = %s.%s;", this.getContentItemTableName(), this.getContentItemTableName(), this.getIdColName()));
            while (personsRs.next()) {
                stmt.addBatch(String.format("INSERT INTO %s (bundle_id) VALUES (%d);", this.getBundleTableName(), personsRs.getInt(1)));
                stmt.addBatch(String.format("UPDATE acs_objects SET default_domain_class = '%s',object_type = '%s' WHERE object_id = %d;", this.getBundleClassName(), this.getBundleClassName(), personsRs.getInt(1)));
            }
            stmt.executeBatch();
        }
        catch (SQLException ex) {
            System.err.println("Failed to fill tables.");
            this.printStackTrace(ex);
            this.rollback(conn);
            this.close(conn);
            return;
        }
        try {
            conn.commit();
        }
        catch (SQLException ex) {
            System.err.println("Failed to commiting modifications.");
            this.printStackTrace(ex);
            this.rollback(conn);
            return;
        }
        this.close(conn);
    }

    private void rollback(Connection conn) {
        try {
            System.err.println("WARNING: Rollback.");
            conn.rollback();
        }
        catch (SQLException ex1) {
            System.err.println("Rollback failed.");
            ex1.printStackTrace(System.err);
        }
    }

    private void close(Connection conn) {
        try {
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("Failed to close JDBC connection.");
            this.printStackTrace(ex);
        }
    }

    private void printStackTrace(SQLException ex) {
        ex.printStackTrace(System.err);
        if (ex.getNextException() != null) {
            this.printStackTrace(ex.getNextException());
        }
    }
}

