/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.dispatcher;

import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.cms.Asset;
import com.arsdigita.cms.ImageAsset;
import com.arsdigita.cms.dispatcher.ResourceHandlerImpl;
import com.arsdigita.dispatcher.DispatcherHelper;
import com.arsdigita.dispatcher.RequestContext;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.mimetypes.MimeType;
import com.arsdigita.persistence.OID;
import com.arsdigita.toolbox.ui.OIDParameter;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class BaseImage
extends ResourceHandlerImpl {
    public static final String IMAGE_ID = "image_id";
    public static final String OID_PARAM = "oid";
    private static final String s_defaultName = "Image";
    private BigDecimalParameter m_imageId = new BigDecimalParameter("image_id");
    private OIDParameter m_oid = new OIDParameter("oid");
    private final boolean m_download;
    private String m_disposition;
    private static final Logger s_log = Logger.getLogger(BaseImage.class);

    public BaseImage(boolean download) {
        this.m_download = download;
        this.m_disposition = this.m_download ? "attachment; filename=" : "inline; filename=";
    }

    protected void setFilenameHeader(HttpServletResponse response, ImageAsset image) {
        String filename = image.getName();
        if (filename == null) {
            filename = s_defaultName;
        }
        StringBuilder disposition = new StringBuilder(this.m_disposition);
        disposition.append('\"').append(filename).append('\"');
        response.setHeader("Content-Disposition", disposition.toString());
    }

    private void setHeaders(HttpServletResponse response, ImageAsset image) {
        this.setFilenameHeader(response, image);
        Long contentLength = new Long(image.getSize());
        response.setContentLength(contentLength.intValue());
        MimeType mimeType = image.getMimeType();
        if (this.m_download || mimeType == null) {
            response.setContentType("application/octet-stream");
        } else {
            response.setContentType(mimeType.getMimeType());
        }
        if ("live".equals(image.getVersion())) {
            DispatcherHelper.cacheForWorld((HttpServletResponse)response);
        } else {
            DispatcherHelper.cacheDisable((HttpServletResponse)response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(HttpServletResponse response, ImageAsset image) throws IOException {
        ServletOutputStream out = response.getOutputStream();
        try {
            image.writeBytes((OutputStream)out);
        }
        finally {
            out.close();
        }
    }

    @Override
    public void dispatch(HttpServletRequest request, HttpServletResponse response, RequestContext actx) throws IOException, ServletException {
        OID oid = null;
        BigDecimal imageId = null;
        try {
            oid = (OID)this.m_oid.transformValue(request);
            imageId = (BigDecimal)this.m_imageId.transformValue(request);
        }
        catch (Exception e) {
            response.sendError(400, e.toString());
            return;
        }
        if (imageId == null && oid == null || imageId != null && oid != null) {
            response.sendError(400, "either image_id or oid is required.");
            return;
        }
        if (oid == null) {
            oid = new OID("com.arsdigita.cms.ImageAsset", (Object)imageId);
        }
        ImageAsset image = null;
        try {
            Asset a = (Asset)DomainObjectFactory.newInstance((OID)oid);
            if (a instanceof ImageAsset) {
                image = (ImageAsset)a;
            } else if (s_log.isInfoEnabled()) {
                s_log.info((Object)("Asset " + oid + " is not an ImageAsset"));
            }
        }
        catch (DataObjectNotFoundException nfe) {
            response.sendError(404, "no ImageAsset with oid " + oid);
            return;
        }
        this.setHeaders(response, image);
        this.send(response, image);
    }
}

