/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.dispatcher;

import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.SecurityManager;
import com.arsdigita.cms.dispatcher.AccessDeniedException;
import com.arsdigita.cms.dispatcher.CMSPage;
import com.arsdigita.cms.dispatcher.ItemResolver;
import com.arsdigita.cms.dispatcher.PageResolver;
import com.arsdigita.cms.dispatcher.ResourceHandler;
import com.arsdigita.cms.dispatcher.XMLGenerator;
import com.arsdigita.cms.publishToFile.LocalRequestPassword;
import com.arsdigita.developersupport.DeveloperSupport;
import com.arsdigita.dispatcher.ChainedDispatcher;
import com.arsdigita.dispatcher.Dispatcher;
import com.arsdigita.dispatcher.DispatcherHelper;
import com.arsdigita.dispatcher.JSPApplicationDispatcher;
import com.arsdigita.dispatcher.RedirectException;
import com.arsdigita.dispatcher.RequestContext;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.ACSObjectCache;
import com.arsdigita.kernel.KernelHelper;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.User;
import com.arsdigita.web.LoginSignal;
import com.arsdigita.web.URL;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class CMSDispatcher
implements Dispatcher,
ChainedDispatcher {
    private static Logger s_log = Logger.getLogger(CMSDispatcher.class);
    public static final String CONTENT_SECTION = "com.arsdigita.cms.dispatcher.section";
    public static final String CONTENT_ITEM = "com.arsdigita.cms.dispatcher.item";
    public static final String[] INDEX_FILES = new String[]{"index.jsp", "index.html", "index.htm"};
    private static final String DEBUG = "/debug";
    private static final String ADMIN_SECTION = "admin";
    public static final String ADMIN_URL = "admin/index";
    public static final String PREVIEW = "preview";
    private static HashMap s_pageResolverCache = new HashMap();
    private static HashMap s_itemResolverCache = new HashMap();
    private static HashMap s_xmlGeneratorCache = new HashMap();
    private boolean m_adminPagesOnly = false;

    public CMSDispatcher() {
        this(false);
    }

    public CMSDispatcher(boolean adminOnly) {
        this.m_adminPagesOnly = adminOnly;
    }

    public void dispatch(HttpServletRequest request, HttpServletResponse response, RequestContext actx) throws IOException, ServletException {
        String remainingUrl;
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Dispatching request for " + new URL(request).toDebugString()));
        }
        DeveloperSupport.startStage((String)"CMSDispatcher.dispatch: get resource");
        String processedUrl = actx.getProcessedURLPart();
        String webappURLContext = request.getContextPath();
        if (processedUrl.startsWith(webappURLContext)) {
            processedUrl = processedUrl.substring(webappURLContext.length());
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Determined the path to the current site node; it is '" + processedUrl + "' according to the " + "request context"));
        }
        if ((remainingUrl = actx.getRemainingURLPart()).endsWith("/")) {
            remainingUrl = remainingUrl.substring(0, remainingUrl.length() - 1);
        } else if (remainingUrl.endsWith(".jsp")) {
            remainingUrl = remainingUrl.substring(0, remainingUrl.length() - ".jsp".length());
        } else if (remainingUrl.equals("")) {
            remainingUrl = "index";
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Determined the path after the current site node; it is '" + remainingUrl + "'"));
        }
        ContentSection section = null;
        try {
            section = this.findContentSection(processedUrl);
        }
        catch (DataObjectNotFoundException e) {
            throw new ServletException((Throwable)e);
        }
        request.setAttribute(CONTENT_SECTION, (Object)section);
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Found content section '" + (Object)((Object)section) + "'"));
        }
        this.checkUserAccess(request, response, actx);
        try {
            s_log.debug((Object)"Looking for a site node asset");
            String siteNodeAssetURL = this.getSiteNodeAsset(request, actx);
            if (siteNodeAssetURL != null) {
                s_log.debug((Object)("Site node asset found at '" + siteNodeAssetURL + "'"));
                DispatcherHelper.cacheDisable((HttpServletResponse)response);
                DispatcherHelper.setRequestContext((HttpServletRequest)request, (RequestContext)actx);
                DispatcherHelper.forwardRequestByPath((String)siteNodeAssetURL, (HttpServletRequest)request, (HttpServletResponse)response);
                return;
            }
            s_log.debug((Object)"No site node asset found; proceeding with normal dispatching");
        }
        catch (RedirectException e) {
            throw new ServletException((Throwable)e);
        }
        ResourceHandler resource = this.getResource(section, remainingUrl);
        DeveloperSupport.endStage((String)"CMSDispatcher.dispatch: get resource");
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Got a resource '" + resource + "'"));
        }
        if (resource != null) {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Found resource '" + remainingUrl + "'; " + "dispatching to it"));
            }
            s_log.info((Object)("resource dispatch for " + remainingUrl));
            DeveloperSupport.startStage((String)"CMSDispatcher.dispatch: resource.dispatch");
            resource.dispatch(request, response, actx);
            DeveloperSupport.endStage((String)"CMSDispatcher.dispatch: resource.dispatch");
        } else {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("No resource found at '" + remainingUrl + "'; " + "searching for a previewable content item at " + "this path"));
            }
            DeveloperSupport.startStage((String)"CMSDispatcher.dispatch: item dispatch");
            boolean preview = false;
            if (remainingUrl.startsWith(PREVIEW)) {
                remainingUrl = remainingUrl.substring(PREVIEW.length());
                preview = true;
            }
            ContentItem item = null;
            SecurityManager sm = new SecurityManager(section);
            if (sm.canAccess(request, "public_pages") && (item = preview ? this.getContentItem(section, remainingUrl, PREVIEW) : this.getContentItem(section, remainingUrl, "live")) != null) {
                request.setAttribute(CONTENT_ITEM, (Object)item);
                ACSObjectCache.set((ServletRequest)request, (ACSObject)item);
            }
            if (item != null) {
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)("Found item " + item + "; serving it"));
                }
                DispatcherHelper.cacheDisable((HttpServletResponse)response);
                this.preview(request, response, actx);
            } else {
                s_log.debug((Object)"No item to preview found; falling back to JSP dispatcher to look for some concrete resource in the file system");
                JSPApplicationDispatcher jsp = JSPApplicationDispatcher.getInstance();
                jsp.dispatch(request, response, actx);
            }
            DeveloperSupport.endStage((String)"CMSDispatcher.dispatch: item dispatch");
        }
    }

    public int chainedDispatch(HttpServletRequest request, HttpServletResponse response, RequestContext actx) throws IOException, ServletException {
        if (this.m_adminPagesOnly) {
            String url = actx.getRemainingURLPart();
            if (url.endsWith(".jsp")) {
                url = url.substring(0, url.length() - ".jsp".length());
            } else if (url.endsWith("/")) {
                url = url.substring(0, url.length() - 1);
            }
            if (url.equals(ADMIN_URL)) {
                if (s_log.isInfoEnabled()) {
                    s_log.info((Object)("Resolving admin URL '" + url + "'"));
                }
                this.dispatch(request, response, actx);
                return 0;
            }
            return 1;
        }
        this.dispatch(request, response, actx);
        return 0;
    }

    protected SecurityManager getSecurityManager(ContentSection section) {
        return new SecurityManager(section);
    }

    protected void checkUserAccess(HttpServletRequest request, HttpServletResponse response, RequestContext actx) throws ServletException, AccessDeniedException {
        User user = KernelHelper.getCurrentUser((HttpServletRequest)request);
        ContentSection section = CMSDispatcher.getContentSection(request);
        SecurityManager sm = this.getSecurityManager(section);
        if (this.isAdminPage(actx.getRemainingURLPart())) {
            if (user == null) {
                this.redirectToLoginPage(request, response);
                return;
            }
            if (!sm.canAccess((Party)user, "admin_pages")) {
                throw new AccessDeniedException("You do not have access to the administrative pages for the " + section.getName() + " content section.");
            }
        } else if (!sm.canAccess((Party)user, "public_pages") && !LocalRequestPassword.validLocalRequest(request)) {
            throw new AccessDeniedException("You do not have access to the public pages for the " + section.getName() + " content section.");
        }
    }

    public static ContentSection getContentSection(HttpServletRequest request) {
        return (ContentSection)((Object)request.getAttribute(CONTENT_SECTION));
    }

    public static ContentItem getContentItem(HttpServletRequest request) {
        return (ContentItem)request.getAttribute(CONTENT_ITEM);
    }

    protected ContentSection findContentSection(String url) throws DataObjectNotFoundException {
        if (url.startsWith(DEBUG)) {
            url = url.substring(DEBUG.length());
        }
        String debugXMLString = "/xml";
        if (url.startsWith("/xml")) {
            url = url.substring("/xml".length());
        }
        String debugXSLString = "/xsl";
        if (url.startsWith("/xsl")) {
            url = url.substring("/xsl".length());
        }
        ContentSection section = ContentSection.getSectionForPath(url);
        return section;
    }

    protected ResourceHandler getResource(ContentSection section, String url) throws ServletException {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Searching for a resource for the URL fragment '" + url + "' under " + (Object)((Object)section)));
        }
        PageResolver pageResolver = CMSDispatcher.getPageResolver(section);
        ResourceHandler handler = pageResolver.getPage(url);
        return handler;
    }

    protected ContentItem getContentItem(ContentSection section, String url, String context) throws ServletException {
        ItemResolver itemResolver = CMSDispatcher.getItemResolver(section);
        ContentItem item = null;
        item = itemResolver.getItem(section, url, context);
        return item;
    }

    protected void preview(HttpServletRequest request, HttpServletResponse response, RequestContext actx) throws IOException, ServletException {
        ContentSection section = CMSDispatcher.getContentSection(request);
        ContentItem item = CMSDispatcher.getContentItem(request);
        ItemResolver itemResolver = CMSDispatcher.getItemResolver(section);
        CMSPage page = itemResolver.getMasterPage(item, request);
        page.dispatch(request, response, actx);
    }

    public static void releaseResource(ContentSection section, String url) {
        section.getPageResolver().releasePage(url);
    }

    public static PageResolver getPageResolver(ContentSection section) {
        s_log.debug((Object)"Getting the page resolver");
        String name = section.getName();
        PageResolver pr = (PageResolver)s_pageResolverCache.get(name);
        if (pr == null) {
            s_log.debug((Object)"The page resolver was not cached; fetching a new one and placing it in the cache");
            pr = section.getPageResolver();
            s_pageResolverCache.put(name, pr);
        }
        return pr;
    }

    public static ItemResolver getItemResolver(ContentSection section) {
        String name = section.getName();
        ItemResolver ir = (ItemResolver)s_itemResolverCache.get(name);
        if (ir == null) {
            ir = section.getItemResolver();
            s_itemResolverCache.put(name, ir);
        }
        return ir;
    }

    public static XMLGenerator getXMLGenerator(ContentSection section) {
        String name = section.getName();
        XMLGenerator xg = (XMLGenerator)s_xmlGeneratorCache.get(name);
        if (xg == null) {
            xg = section.getXMLGenerator();
            s_xmlGeneratorCache.put(name, xg);
        }
        return xg;
    }

    protected boolean isAdminPage(String url) {
        if (url.startsWith(DEBUG)) {
            url = url.substring(DEBUG.length());
        }
        return url != null && (url.startsWith(ADMIN_SECTION) || url.startsWith(PREVIEW));
    }

    protected void redirectToLoginPage(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        throw new LoginSignal(req);
    }

    private String getSiteNodeAsset(HttpServletRequest request, RequestContext actx) throws RedirectException {
        String siteNodeAssetURL = null;
        ServletContext sctx = actx.getServletContext();
        String processedURL = actx.getProcessedURLPart();
        String remainingURL = actx.getRemainingURLPart();
        String templateRoot = null;
        if (null == templateRoot) {
            return null;
        }
        File siteNodeAssetRoot = new File(templateRoot, processedURL);
        File assetFile = new File(siteNodeAssetRoot, remainingURL);
        String contextPath = request.getContextPath();
        if (assetFile.isDirectory()) {
            if (remainingURL.endsWith("/")) {
                throw new RedirectException(actx.getOriginalURL() + "/");
            }
            for (int i = 0; i < INDEX_FILES.length; ++i) {
                File indexFile = new File(assetFile, INDEX_FILES[i]);
                if (!indexFile.exists()) continue;
                assetFile = indexFile;
            }
        }
        if (assetFile.exists()) {
            siteNodeAssetURL = contextPath + "/" + templateRoot + processedURL + remainingURL;
        }
        return siteNodeAssetURL;
    }
}

