/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.dispatcher;

import com.arsdigita.templating.Templating;
import com.arsdigita.util.IO;
import com.arsdigita.util.servlet.HttpParameterMap;
import com.arsdigita.util.servlet.HttpResourceLocator;
import com.arsdigita.web.BaseServlet;
import com.arsdigita.web.Web;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class ContentItemXSLServlet
extends BaseServlet {
    private static final Logger s_log = Logger.getLogger(ContentItemXSLServlet.class);
    public static Map s_templateResolverCache = Collections.synchronizedMap(new HashMap());

    protected void doService(HttpServletRequest sreq, HttpServletResponse sresp) throws ServletException, IOException {
        String oid = sreq.getParameter("oid");
        String delegated = sreq.getParameter("delegated");
        String context = sreq.getParameter("context");
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Template OID is " + oid));
            s_log.debug((Object)("Delegated URL is " + delegated));
        }
        if (oid == null || delegated == null) {
            sresp.sendError(404, "Page Not Found");
            return;
        }
        ArrayList<URL> paths = new ArrayList<URL>();
        HttpParameterMap params = new HttpParameterMap();
        params.setParameter("oid", oid);
        HttpResourceLocator loc = new HttpResourceLocator(Web.getConfig().getHost(), Web.getConfig().getDispatcherContextPath(), "/themes/servlet/template", "/index.xsl", params);
        try {
            paths.add(new URL(delegated));
            paths.add(loc.toURL());
        }
        catch (MalformedURLException me) {
            s_log.warn((Object)("Malformed URL of " + delegated), (Throwable)me);
            sresp.sendError(404, "Page Not Found");
            return;
        }
        InputStream is = Templating.multiplexXSLFiles(paths.iterator());
        sresp.setContentType("text/xml; charset=UTF-8");
        IO.copy((InputStream)is, (OutputStream)sresp.getOutputStream());
    }
}

