/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.dispatcher;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleComponent;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.dispatcher.XMLGenerator;
import com.arsdigita.dispatcher.DispatcherHelper;
import com.arsdigita.util.Assert;
import com.arsdigita.xml.Element;

public class ContentPanel
extends SimpleComponent {
    protected XMLGenerator getXMLGenerator(PageState state) {
        ContentSection section = CMS.getContext().getContentSection();
        Assert.exists((Object)((Object)section));
        return section.getXMLGenerator();
    }

    public void generateXML(PageState state, Element parent) {
        if (this.isVisible(state)) {
            Element content = parent.newChildElement("cms:contentPanel", "http://www.arsdigita.com/cms/1.0");
            this.exportAttributes(content);
            this.generatePathInfoXML(state, content);
            XMLGenerator xmlGenerator = this.getXMLGenerator(state);
            xmlGenerator.generateXML(state, content, null);
        }
    }

    protected void generatePathInfoXML(PageState state, Element parent) {
        String url;
        Element pathInfo = parent.newChildElement("cms:pathInfo", "http://www.arsdigita.com/cms/1.0");
        if (CMS.getContext().hasContentSection()) {
            pathInfo.newChildElement("cms:sectionPath", "http://www.arsdigita.com/cms/1.0").setText(CMS.getContext().getContentSection().getPath());
        }
        if ((url = DispatcherHelper.getRequestContext().getRemainingURLPart()).startsWith("preview")) {
            pathInfo.newChildElement("cms:previewPath", "http://www.arsdigita.com/cms/1.0").setText("/preview");
        }
        pathInfo.newChildElement("cms:templatePrefix", "http://www.arsdigita.com/cms/1.0").setText("/tem_");
        if (CMS.getContext().hasContentItem()) {
            ContentItem item = CMS.getContext().getContentItem();
            ContentItem bundle = (ContentItem)item.getDraftVersion().getParent();
            pathInfo.newChildElement("cms:itemPath", "http://www.arsdigita.com/cms/1.0").setText("/" + bundle.getPath());
        }
    }
}

