/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.dispatcher;

import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.SecurityManager;
import com.arsdigita.cms.dispatcher.CMSDispatcher;
import com.arsdigita.cms.dispatcher.FileDispatcher;
import com.arsdigita.cms.dispatcher.ItemDispatcher;
import com.arsdigita.dispatcher.ChainedDispatcher;
import com.arsdigita.dispatcher.Dispatcher;
import com.arsdigita.dispatcher.DispatcherChain;
import com.arsdigita.dispatcher.RequestContext;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelContext;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.User;
import com.arsdigita.sitenode.SiteNodeRequestContext;
import com.arsdigita.util.Assert;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ContentSectionDispatcher
implements Dispatcher {
    public static final String CONTENT_ITEM = "com.arsdigita.cms.dispatcher.item";
    static final String CONTENT_SECTION = "com.arsdigita.cms.dispatcher.section";
    private DispatcherChain dispatcherChain = new DispatcherChain();

    public ContentSectionDispatcher() {
        this.dispatcherChain.addChainedDispatcher((ChainedDispatcher)new CMSDispatcher(true));
        this.dispatcherChain.addChainedDispatcher((ChainedDispatcher)new FileDispatcher());
        this.dispatcherChain.addChainedDispatcher((ChainedDispatcher)new ItemDispatcher());
        this.dispatcherChain.addChainedDispatcher((ChainedDispatcher)new CMSDispatcher());
    }

    public void dispatch(HttpServletRequest request, HttpServletResponse response, RequestContext context) throws IOException, ServletException {
        this.setContentSection(request, (SiteNodeRequestContext)context);
        this.dispatcherChain.dispatch(request, response, context);
    }

    public static ContentSection getContentSection(HttpServletRequest request) {
        return (ContentSection)((Object)request.getAttribute(CONTENT_SECTION));
    }

    public static ContentItem getContentItem(HttpServletRequest request) {
        return (ContentItem)request.getAttribute(CONTENT_ITEM);
    }

    private void setContentSection(HttpServletRequest request, SiteNodeRequestContext actx) throws ServletException {
        try {
            ContentSection section = (ContentSection)ContentSection.getCurrentApplication((HttpServletRequest)request);
            Assert.exists((Object)((Object)section));
            request.setAttribute(CONTENT_SECTION, (Object)section);
        }
        catch (DataObjectNotFoundException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public static boolean checkAdminAccess(HttpServletRequest request, ContentSection section) {
        KernelContext kernelContext = Kernel.getContext();
        if (!(kernelContext.getParty() instanceof User)) {
            return false;
        }
        User user = (User)kernelContext.getParty();
        SecurityManager sm = new SecurityManager(section);
        return sm.canAccess((Party)user, "admin_pages");
    }
}

