/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.dispatcher;

import com.arsdigita.cms.dispatcher.Resource;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;

public class ResourceType
extends DomainObject {
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.ResourceType";
    private static final String ID = "id";
    private static final String CLASSNAME = "baseClass";
    private static final String LABEL = "label";
    private static final String DESCRIPTION = "description";

    public ResourceType() {
        super(BASE_DATA_OBJECT_TYPE);
    }

    public ResourceType(String type) {
        super(type);
    }

    public ResourceType(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public ResourceType(DataObject obj) {
        super(obj);
    }

    public String getID() {
        return (String)this.get(ID);
    }

    public String getLabel() {
        return (String)this.get(LABEL);
    }

    public String getDescription() {
        return (String)this.get(DESCRIPTION);
    }

    public String getBaseClassName() {
        return (String)this.get(CLASSNAME);
    }

    private void setID(String id) {
        this.set(ID, id);
    }

    public void setLabel(String s) {
        this.set(LABEL, s);
    }

    public void setDescription(String s) {
        this.set(DESCRIPTION, s);
    }

    public void setBaseClassName(String s) {
        this.set(CLASSNAME, s);
    }

    public Resource createInstance(String className) {
        return Resource.create(this, className);
    }

    public static ResourceType createResourceType(String id, String baseClass, String label, String description) {
        ResourceType resourceType = new ResourceType();
        resourceType.setBaseClassName(baseClass);
        resourceType.setID(id);
        resourceType.setLabel(label);
        if (description != null) {
            resourceType.setDescription(description);
        }
        return resourceType;
    }

    public static ResourceType createResourceType(String id, String baseClass, String label) {
        return ResourceType.createResourceType(id, baseClass, label, null);
    }

    public static ResourceType findResourceType(String id) throws DataObjectNotFoundException {
        Session session = SessionManager.getSession();
        DataQuery dq = session.retrieveQuery("com.arsdigita.cms.getResourceTypes");
        Filter f = dq.addFilter("id = :id");
        f.set(ID, (Object)id);
        ResourceType type = null;
        String typeId = null;
        if (dq.next()) {
            typeId = (String)dq.get(ID);
            type = new ResourceType(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
            dq.close();
        }
        return type;
    }
}

