/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.dispatcher;

import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.dispatcher.PageResolver;
import com.arsdigita.cms.dispatcher.Resource;
import com.arsdigita.cms.dispatcher.ResourceHandler;
import com.arsdigita.cms.dispatcher.ResourceMapping;
import com.arsdigita.cms.dispatcher.ResourceType;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.UncheckedWrapperException;
import javax.servlet.ServletException;
import org.apache.log4j.Logger;

public class SimplePageResolver
extends PageResolver {
    private static final Logger s_log = Logger.getLogger(SimplePageResolver.class);

    @Override
    public ResourceHandler getPage(String url) {
        ResourceHandler page;
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Getting the resource handler for the url '" + url + "'"));
        }
        if ((page = super.getPage(url)) == null) {
            s_log.debug((Object)"Getting the correct page from the database");
            Session session = SessionManager.getSession();
            DataQuery dq = session.retrieveQuery("com.arsdigita.cms.getResourceMappings");
            Filter f = dq.addFilter("sectionId = :sectionId and url = :url");
            f.set("sectionId", (Object)this.getContentSectionID());
            f.set("url", (Object)url);
            String className = null;
            s_log.debug((Object)"Getting the page resolver's class name from the database");
            if (dq.next()) {
                className = (String)dq.get("className");
                dq.close();
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)("Got the class name '" + className + "' from the database"));
                }
                try {
                    page = (ResourceHandler)Class.forName(className).newInstance();
                    if (s_log.isDebugEnabled()) {
                        s_log.debug((Object)("Loaded instance " + page + "; " + "initializing it"));
                    }
                    page.init();
                    s_log.debug((Object)"Storing the page in the resolver cache");
                    this.loadPage(url, page);
                }
                catch (ClassNotFoundException cnfe) {
                    throw new UncheckedWrapperException((Throwable)cnfe);
                }
                catch (InstantiationException ie) {
                    throw new UncheckedWrapperException((Throwable)ie);
                }
                catch (IllegalAccessException iae) {
                    throw new UncheckedWrapperException((Throwable)iae);
                }
                catch (ServletException se) {
                    throw new UncheckedWrapperException((Throwable)se);
                }
            } else {
                s_log.debug((Object)"No class name was found");
            }
        }
        return page;
    }

    @Override
    public void registerPage(ResourceHandler page, String url) {
        Resource resource = null;
        ResourceType type = null;
        ResourceMapping mapping = null;
        ContentSection sec = new ContentSection(this.getContentSectionID());
        resource = Resource.findResource(sec, url);
        if (resource == null) {
            type = ResourceType.findResourceType("xml");
            resource = type.createInstance(page.getClass().getName());
        }
        mapping = resource.createInstance(sec, url);
        mapping.save();
    }

    @Override
    public void unregisterPage(ResourceHandler page, String url) {
        Resource resource = null;
        ContentSection sec = new ContentSection(this.getContentSectionID());
        resource = Resource.findResource(sec, url);
        if (resource != null) {
            resource.delete();
        }
    }
}

