/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.dispatcher;

import com.arsdigita.bebop.PageState;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentItemXMLRenderer;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ExtraXMLGenerator;
import com.arsdigita.cms.UserDefinedContentItem;
import com.arsdigita.cms.dispatcher.CMSPage;
import com.arsdigita.cms.dispatcher.XMLGenerator;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.domain.DomainObjectTraversal;
import com.arsdigita.domain.DomainObjectTraversalAdapter;
import com.arsdigita.domain.SimpleDomainObjectTraversalAdapter;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.metadata.DynamicObjectType;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.metadata.Property;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.xml.Element;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class SimpleXMLGenerator
implements XMLGenerator {
    private static final Logger s_log = Logger.getLogger(SimpleXMLGenerator.class);
    public static final String ADAPTER_CONTEXT = SimpleXMLGenerator.class.getName();
    private boolean useExtraXml = true;
    private boolean listMode = false;
    private Map<String, String> itemAttributes = new LinkedHashMap<String, String>();
    private String itemElemName = "cms:item";
    private String itemElemNs = "http://www.arsdigita.com/cms/1.0";

    public void setUseExtraXml(boolean useExtraXml) {
        this.useExtraXml = useExtraXml;
    }

    public void setListMode(boolean listMode) {
        this.listMode = listMode;
    }

    public void addItemAttribute(String name, String value) {
        this.itemAttributes.put(name, value);
    }

    public void setItemElemName(String itemElemName, String itemElemNs) {
        this.itemElemName = itemElemName;
        this.itemElemNs = itemElemNs;
    }

    @Override
    public void generateXML(PageState state, Element parent, String useContext) {
        PermissionDescriptor publish;
        PermissionDescriptor edit;
        ContentSection section = CMS.getContext().getContentSection();
        ContentItem item = this.getContentItem(state);
        s_log.info((Object)("Generate XML for item " + item.getOID()));
        Party currentParty = Kernel.getContext().getParty();
        if (currentParty == null) {
            currentParty = Kernel.getPublicUser();
        }
        if (PermissionService.checkPermission((PermissionDescriptor)(edit = new PermissionDescriptor(PrivilegeDescriptor.get((String)"cms_edit_item"), (ACSObject)item, currentParty)))) {
            parent.addAttribute("canEdit", "true");
        }
        if (PermissionService.checkPermission((PermissionDescriptor)(publish = new PermissionDescriptor(PrivilegeDescriptor.get((String)"cms_publish"), (ACSObject)item, currentParty)))) {
            parent.addAttribute("canPublish", "true");
        }
        String className = item.getDefaultDomainClass();
        if (!item.getClass().getName().equals(className)) {
            s_log.info((Object)"Specializing item");
            try {
                item = (ContentItem)DomainObjectFactory.newInstance((OID)new OID(item.getObjectType().getQualifiedName(), (Object)item.getID()));
            }
            catch (DataObjectNotFoundException ex) {
                throw new UncheckedWrapperException((String)GlobalizationUtil.globalize("cms.dispatcher.cannot_find_domain_object").localize(), (Throwable)ex);
            }
        }
        if (item instanceof XMLGenerator) {
            s_log.info((Object)"Item implements XMLGenerator interface");
            XMLGenerator xitem = (XMLGenerator)((Object)item);
            xitem.generateXML(state, parent, useContext);
        } else if (className.equals("com.arsdigita.cms.UserDefinedContentItem")) {
            s_log.info((Object)"Item is a user defined content item");
            UserDefinedContentItem UDItem = (UserDefinedContentItem)item;
            this.generateUDItemXML(UDItem, state, parent, useContext);
        } else {
            s_log.info((Object)"Item is using DomainObjectXMLRenderer");
            Element content = this.startElement(useContext, parent);
            ContentItemXMLRenderer renderer = new ContentItemXMLRenderer(content);
            renderer.setWrapAttributes(true);
            renderer.setWrapRoot(false);
            renderer.setWrapObjects(false);
            renderer.setRevisitFullObject(true);
            renderer.walk((DomainObject)item, ADAPTER_CONTEXT);
            if (this.useExtraXml) {
                for (ExtraXMLGenerator generator : item.getExtraXMLGenerators()) {
                    generator.setListMode(this.listMode);
                    generator.generateXML(item, content, state);
                }
            }
        }
    }

    protected ContentItem getContentItem(PageState state) {
        if (CMS.getContext().hasContentItem()) {
            return CMS.getContext().getContentItem();
        }
        CMSPage page = (CMSPage)state.getPage();
        return page.getContentItem(state);
    }

    protected void generateUDItemXML(UserDefinedContentItem UDItem, PageState state, Element parent, String useContext) {
        Element element = this.startElement(useContext, parent);
        Element additionalAttrs = this.UDItemElement(useContext);
        element.addAttribute("type", UDItem.getContentType().getLabel());
        element.addAttribute("id", UDItem.getID().toString());
        element.addAttribute("name", UDItem.getName());
        element.addAttribute("title", UDItem.getTitle());
        element.addAttribute("javaClass", UDItem.getContentType().getClassName());
        DynamicObjectType dot = new DynamicObjectType(UDItem.getSpecificObjectType());
        Iterator declaredProperties = dot.getObjectType().getDeclaredProperties();
        Property currentProperty = null;
        Object value = null;
        while (declaredProperties.hasNext()) {
            currentProperty = (Property)declaredProperties.next();
            value = UDItem.get(currentProperty.getName());
            if (value != null) {
                element.addContent(this.UDItemAttrElement(currentProperty.getName(), value.toString()));
                continue;
            }
            element.addContent(this.UDItemAttrElement(currentProperty.getName(), "none specified"));
        }
    }

    private Element startElement(String useContext, Element parent) {
        Element element = parent.newChildElement(this.itemElemName, this.itemElemNs);
        if (useContext != null) {
            element.addAttribute("useContext", useContext);
        }
        for (Map.Entry<String, String> attr : this.itemAttributes.entrySet()) {
            element.addAttribute(attr.getKey(), attr.getValue());
        }
        return element;
    }

    private Element UDItemElement(String useContext) {
        Element element = new Element("cms:UDItemAttributes", "http://www.arsdigita.com/cms/1.0");
        return element;
    }

    private Element UDItemAttrElement(String name, String value) {
        Element element = new Element("cms:UDItemAttribute", "http://www.arsdigita.com/cms/1.0");
        element.addAttribute("UDItemAttrName", name);
        element.addAttribute("UDItemAttrValue", value);
        return element;
    }

    static {
        s_log.debug((Object)"Static initializer starting...");
        SimpleDomainObjectTraversalAdapter adapter = new SimpleDomainObjectTraversalAdapter();
        adapter.addAssociationProperty("/object/type");
        adapter.addAssociationProperty("/object/categories");
        DomainObjectTraversal.registerAdapter((String)"com.arsdigita.cms.ContentItem", (DomainObjectTraversalAdapter)adapter, (String)ADAPTER_CONTEXT);
        s_log.debug((Object)"Static initializer finished");
    }
}

