/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.dispatcher;

import com.arsdigita.cms.Template;
import com.arsdigita.cms.dispatcher.ContentItemXSLServlet;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.persistence.OID;
import com.arsdigita.util.IO;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.web.BaseServlet;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class TemplateXSLServlet
extends BaseServlet {
    private static final Logger s_log = Logger.getLogger(ContentItemXSLServlet.class);
    public static Map s_templateResolverCache = Collections.synchronizedMap(new HashMap());

    protected void doService(HttpServletRequest sreq, HttpServletResponse sresp) throws ServletException, IOException {
        String oid = sreq.getParameter("oid");
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Template OID is " + oid));
        }
        if (oid == null) {
            sresp.sendError(404, "Page Not Found; No oid specified");
            return;
        }
        Template template = null;
        try {
            template = (Template)DomainObjectFactory.newInstance((OID)OID.valueOf((String)oid));
        }
        catch (DataObjectNotFoundException ex) {
            sresp.sendError(404, "Page not found; Cannot retrieve template");
            return;
        }
        ByteArrayInputStream is = null;
        try {
            is = new ByteArrayInputStream(template.getText().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            throw new UncheckedWrapperException("Cannot convert to UTF-8");
        }
        sresp.setContentType("text/xml; charset=UTF-8");
        IO.copy((InputStream)is, (OutputStream)sresp.getOutputStream());
    }
}

