/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.dispatcher;

import com.arsdigita.bebop.PageState;
import com.arsdigita.cms.BinaryAsset;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ImageAsset;
import com.arsdigita.cms.SecurityManager;
import com.arsdigita.cms.Service;
import com.arsdigita.cms.Workspace;
import com.arsdigita.cms.WorkspaceServlet;
import com.arsdigita.cms.dispatcher.CMSDispatcher;
import com.arsdigita.dispatcher.DispatcherHelper;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelContext;
import com.arsdigita.kernel.User;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class Utilities {
    private static HashMap m_cache = new HashMap();
    private static Date s_lastSectionRefresh = null;
    private static Map s_sectionRefreshTimes = Collections.synchronizedMap(new HashMap());
    public static final Logger LOG = Logger.getLogger(Utilities.class);

    public static String getWorkspaceURL() {
        return Workspace.getURL();
    }

    public static String getServiceURL() {
        String url = (String)m_cache.get("cms-service");
        if (url == null) {
            url = Service.getURL();
            m_cache.put("cms-service", url);
        }
        return url;
    }

    public static String getLogoutURL() {
        StringBuilder buf = new StringBuilder(Service.getURL());
        buf.append("logout");
        return buf.toString();
    }

    public static String getAssetURL(BinaryAsset asset) {
        return Utilities.getAssetURL(asset.getID());
    }

    public static String getAssetURL(BigDecimal assetId) {
        StringBuilder buf = new StringBuilder(Service.getURL());
        buf.append("stream/asset?");
        buf.append("asset_id").append("=").append(assetId);
        return buf.toString();
    }

    public static String getImageURL(ImageAsset asset) {
        StringBuilder buf = new StringBuilder(Service.getURL());
        buf.append("stream/image/?");
        buf.append("image_id").append("=").append(asset.getID());
        return buf.toString();
    }

    public static String getImageOID(ImageAsset asset) {
        String oid = asset.getOID().toString();
        return oid;
    }

    public static String getGlobalAssetsURL() {
        return Utilities.getWebappContext();
    }

    public static String getWebappContext() {
        return DispatcherHelper.getWebappContext();
    }

    public static synchronized Date getLastSectionRefresh(ContentSection section) {
        String sectionURL = section.getURL();
        Date lastModified = (Date)s_sectionRefreshTimes.get(sectionURL);
        if (lastModified == null) {
            s_lastSectionRefresh = lastModified = new Date();
            s_sectionRefreshTimes.put(sectionURL, lastModified);
        }
        return lastModified;
    }

    public static Date getLastSectionRefresh() {
        if (s_lastSectionRefresh == null) {
            s_lastSectionRefresh = new Date();
        }
        return s_lastSectionRefresh;
    }

    public static void refreshItemUI(PageState state) {
        ContentSection section = CMS.getContext().getContentSection();
        CMSDispatcher.releaseResource(section, "admin/item");
        WorkspaceServlet.releaseResource("");
        WorkspaceServlet.releaseResource("index");
        Utilities.refreshAdminUI(state);
        s_lastSectionRefresh = new Date();
        s_sectionRefreshTimes.put(section.getURL(), s_lastSectionRefresh);
    }

    public static void refreshAdminUI(PageState state) {
        ContentSection section = CMS.getContext().getContentSection();
        CMSDispatcher.releaseResource(section, "admin");
        CMSDispatcher.releaseResource(section, "admin/index");
        CMSDispatcher.releaseResource(section, "");
        WorkspaceServlet.releaseResource("");
        WorkspaceServlet.releaseResource("index");
    }

    public static void disableBrowserCache(HttpServletResponse response) {
        response.addHeader("pragma", "no-cache");
    }

    public static User getCurrentUser(HttpServletRequest request) {
        KernelContext kernelContext = Kernel.getContext();
        if (kernelContext.getParty() instanceof User) {
            return (User)kernelContext.getParty();
        }
        return null;
    }

    public static SecurityManager getSecurityManager(PageState state) {
        ContentSection section = CMS.getContext().getContentSection();
        return new SecurityManager(section);
    }
}

