/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.lifecycle;

import com.arsdigita.util.Assert;

public class Duration {
    public static String formatDuration(Integer minutes) {
        Assert.exists((Object)minutes, (String)"minutes");
        return Duration.formatDuration((int)minutes);
    }

    public static String formatDuration(int minutes) {
        int[] dhm = Duration.formatDHM(minutes);
        StringBuffer buffer = new StringBuffer();
        if (dhm[0] > 0) {
            buffer.append(dhm[0]).append(" days");
        }
        if (dhm[1] > 0) {
            if (dhm[0] > 0) {
                buffer.append(", ");
            }
            buffer.append(dhm[1]).append(" hours");
        }
        if (dhm[0] > 0 || dhm[1] > 0) {
            buffer.append(", ");
        }
        buffer.append(dhm[2]).append(" minutes");
        return buffer.toString();
    }

    public static int[] formatDHM(int minutes) {
        int[] dhm = new int[3];
        int days = minutes / 1440;
        int hours = minutes / 60;
        int mins = minutes;
        if (days > 0) {
            hours -= days * 24;
            mins -= days * 24 * 60;
        }
        if (hours > 0) {
            mins -= hours * 60;
        }
        dhm[0] = days;
        dhm[1] = hours;
        dhm[2] = mins;
        return dhm;
    }

    public static Integer[] formatDHM(Integer minutes) {
        int[] dhm = Duration.formatDHM((int)minutes);
        return Duration.copyArray(dhm);
    }

    private static Integer[] copyArray(int[] from) {
        Assert.exists((Object)from, (String)"from");
        Integer[] to = new Integer[from.length];
        for (int ii = 0; ii < from.length; ++ii) {
            to[ii] = new Integer(from[ii]);
        }
        return to;
    }
}

