/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.lifecycle;

import com.arsdigita.cms.lifecycle.LifecycleDefinition;
import com.arsdigita.cms.lifecycle.LifecycleEvent;
import com.arsdigita.cms.lifecycle.LifecycleListener;
import com.arsdigita.cms.lifecycle.Phase;
import com.arsdigita.cms.lifecycle.PhaseCollection;
import com.arsdigita.cms.lifecycle.PhaseDefinition;
import com.arsdigita.cms.lifecycle.PublishingException;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.persistence.CompoundFilter;
import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataAssociationCursor;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.FilterFactory;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.log4j.Logger;

public class Lifecycle
extends ACSObject {
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.Lifecycle";
    private final String START_DATE_TIME = "startDateTime";
    private final String END_DATE_TIME = "endDateTime";
    private final String LISTENER = "listener";
    private final String HAS_BEGUN = "hasBegun";
    private final String HAS_ENDED = "hasEnded";
    private final String DEFINITION = "definition";
    private final String PHASES = "phases";
    private static final String CYCLE_ID = "cycleId";
    private static final String OBJECT_ID = "objectId";
    private static final String OBJECT_TYPE = "objectType";
    private static final Logger s_log = Logger.getLogger(Lifecycle.class);

    protected Lifecycle() {
        super(BASE_DATA_OBJECT_TYPE);
    }

    protected void initialize() {
        super.initialize();
        if (this.isNew()) {
            this.set("hasBegun", Boolean.FALSE);
            this.set("hasEnded", Boolean.FALSE);
        }
    }

    public Lifecycle(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public Lifecycle(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public Lifecycle(DataObject obj) {
        super(obj);
    }

    protected Lifecycle(String type) {
        super(type);
    }

    public String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public void beforeDelete() {
        s_log.debug((Object)("About to delete lifecycle " + this.getID() + ". First delete phases & LifecycleService"));
        super.beforeDelete();
        DataCollection lifecycleServices = SessionManager.getSession().retrieve("com.arsdigita.cms.LifecycleService");
        lifecycleServices.addEqualsFilter("lifecycle.id", (Object)this.getID());
        while (lifecycleServices.next()) {
            DataObject service = lifecycleServices.getDataObject();
            s_log.debug((Object)("Deleting lifecycle service " + service.getOID()));
            service.delete();
        }
        PhaseCollection phases = this.getPhases();
        while (phases.next()) {
            phases.getPhase().delete(false);
        }
    }

    public String getLabel() {
        LifecycleDefinition def = this.getLifecycleDefinition();
        if (def == null) {
            return null;
        }
        return def.getLabel();
    }

    public Date getStartDate() {
        return (Date)this.get("startDateTime");
    }

    public void setStartDate(Date date) {
        this.set("startDateTime", date);
    }

    public Date getEndDate() {
        return (Date)this.get("endDateTime");
    }

    public void setEndDate(Date date) {
        this.set("endDateTime", date);
    }

    public String getListenerClassName() {
        return (String)this.get("listener");
    }

    public LifecycleListener getListener() {
        String listenerClassName = this.getListenerClassName();
        LifecycleListener listener = null;
        if (listenerClassName != null) {
            try {
                Class<?> listenerClass = Class.forName(listenerClassName);
                listener = (LifecycleListener)listenerClass.newInstance();
            }
            catch (Exception e) {
                s_log.error((Object)"Error instantiating", (Throwable)e);
                throw new PublishingException("Error instantiating lifecycle listener: " + listenerClassName, e);
            }
        }
        return listener;
    }

    public void setListenerClassName(String listener) {
        this.set("listener", listener);
    }

    public boolean hasBegun() {
        return (Boolean)this.get("hasBegun");
    }

    protected void setHasBegun(boolean hasBegun) {
        this.set("hasBegun", new Boolean(hasBegun));
    }

    public boolean hasEnded() {
        return (Boolean)this.get("hasEnded");
    }

    public LifecycleDefinition getLifecycleDefinition() {
        DataObject definition = (DataObject)this.get("definition");
        if (definition == null) {
            return null;
        }
        return new LifecycleDefinition(definition);
    }

    protected void setLifecycleDefinition(LifecycleDefinition definition) {
        this.setAssociation("definition", (DomainObject)definition);
    }

    public PhaseCollection getPhases() {
        DataAssociationCursor phaseCursor = ((DataAssociation)this.get("phases")).cursor();
        return new PhaseCollection((DataCollection)phaseCursor);
    }

    public PhaseCollection getActivePhases() {
        return this.getActivePhases(null);
    }

    public PhaseCollection getActivePhases(Date date) {
        if (date == null) {
            date = new Date();
        }
        DataAssociationCursor dac = ((DataAssociation)this.get("phases")).cursor();
        FilterFactory factory = dac.getFilterFactory();
        CompoundFilter filter = factory.and().addFilter(factory.simple("startDateTime <= :startDateTime")).addFilter((Filter)factory.or().addFilter(factory.equals("endDateTime", null)).addFilter("endDateTime >= :endDateTimeValue"));
        filter.set("startDateTime", (Object)date);
        filter.set("endDateTimeValue", (Object)date);
        dac.addFilter((Filter)filter);
        return new PhaseCollection((DataCollection)dac);
    }

    public Phase addPhase(PhaseDefinition pd) {
        return this.addPhase(pd, null);
    }

    public Phase addPhase(PhaseDefinition pd, Date startDate) {
        return this.addPhase(pd, startDate, null);
    }

    public Phase addPhase(PhaseDefinition pd, Date startDate, Date endDate) {
        Integer duration;
        BigDecimal cycleDefId = pd.getLifecycleDefinition().getID();
        if (!cycleDefId.equals(this.getLifecycleDefinition().getID())) {
            throw new PublishingException("The phase definition does not correspond to the lifecycle definition.");
        }
        Phase phase = new Phase();
        phase.setPhaseDefinition(pd);
        phase.setLifecycle(this);
        phase.setListenerClassName(pd.getDefaultListener());
        if (startDate == null) {
            Integer delay = pd.getDefaultDelay();
            long start = System.currentTimeMillis() + delay.longValue() * 60L * 1000L;
            startDate = new Date(start);
        }
        if (endDate == null && (duration = pd.getDefaultDuration()) != null) {
            long end = startDate.getTime() + duration.longValue() * 60L * 1000L;
            endDate = new Date(end);
        }
        phase.setStartDate(startDate);
        phase.setEndDate(endDate);
        return phase;
    }

    public Phase addCustomPhase(String label, Date startDate, Date endDate) {
        PhaseDefinition pd = new PhaseDefinition();
        pd.setLabel(label);
        pd.save();
        Phase phase = new Phase();
        phase.setPhaseDefinition(pd);
        phase.setLifecycle(this);
        phase.setStartDate(startDate);
        phase.setEndDate(endDate);
        return phase;
    }

    public Phase addCustomPhase(String label, Long start, Long end) {
        PhaseDefinition pd = new PhaseDefinition();
        pd.setLabel(label);
        pd.save();
        Phase phase = new Phase();
        phase.setPhaseDefinition(pd);
        phase.setLifecycle(this);
        phase.setStartTime(start);
        phase.setEndTime(end);
        return phase;
    }

    public void start() {
        if (!this.hasBegun()) {
            Date now = new Date();
            Date startDate = this.getStartDate();
            if (startDate == null) {
                startDate = now;
            }
            if (startDate.before(now) || startDate.equals(now)) {
                this.fireListeners();
            }
            PhaseCollection phases = this.getActivePhases();
            while (phases.next()) {
                phases.getPhase().start();
            }
        }
    }

    private void fireListeners() {
        LifecycleListener listener = this.getListener();
        if (listener != null) {
            Session ssn = SessionManager.getSession();
            DataQuery dq = ssn.retrieveQuery("com.arsdigita.cms.getObjectLifecycleMappings");
            Filter f = dq.addEqualsFilter(CYCLE_ID, (Object)this.getID());
            while (dq.next()) {
                BigDecimal objectId = (BigDecimal)dq.get(OBJECT_ID);
                String objectType = (String)dq.get(OBJECT_TYPE);
                LifecycleEvent event = new LifecycleEvent(1, this.getStartDate(), this.getEndDate(), objectType, objectId);
                try {
                    listener.begin(event);
                    this.setHasBegun(true);
                    this.save();
                }
                catch (Exception e) {
                    s_log.error((Object)"Error in firing listeners", (Throwable)e);
                    dq.close();
                    throw new PublishingException(e.getMessage(), e);
                }
            }
        }
    }

    protected void stop() {
        this.set("hasEnded", Boolean.TRUE);
    }

    void updateStartEndTimes() {
        Date origStart = this.getStartDate();
        Date origEnd = this.getEndDate();
        PhaseCollection phases = this.getPhases();
        Date minStartDate = null;
        Date maxEndDate = null;
        boolean hasPhases = false;
        boolean phaseCount = false;
        while (phases.next()) {
            Phase phase = phases.getPhase();
            Date startDate = phase.getStartDate();
            Date endDate = phase.getEndDate();
            if (!hasPhases) {
                minStartDate = startDate;
                maxEndDate = endDate;
                hasPhases = true;
                continue;
            }
            if (startDate.before(minStartDate)) {
                minStartDate = startDate;
            }
            if (endDate == null) {
                maxEndDate = null;
                continue;
            }
            if (maxEndDate == null || !endDate.after(maxEndDate)) continue;
            maxEndDate = endDate;
        }
        if (origStart == null || !origStart.equals(minStartDate) || origEnd == null && maxEndDate != null || origEnd != null && maxEndDate == null || origEnd != null && !origEnd.equals(maxEndDate)) {
            this.setStartDate(minStartDate);
            this.setEndDate(maxEndDate);
            this.save();
        }
    }

    public void reset() {
        PhaseCollection existingPhases = this.getPhases();
        Date finalEndDate = null;
        long timeExpired = new Date().getTime() - this.getStartDate().getTime();
        existingPhases.addOrder("endDateTime");
        while (existingPhases.next()) {
            Phase existingPhase = existingPhases.getPhase();
            PhaseDefinition phaseDefinition = existingPhase.getPhaseDefinition();
            LifecycleDefinition lifeCycleDef = phaseDefinition.getLifecycleDefinition();
            Date startDate = new Date(existingPhase.getStartDate().getTime() + timeExpired);
            if (existingPhase.getEndDate() != null) {
                Date endDate = new Date(existingPhase.getEndDate().getTime() + timeExpired);
                Phase phase = lifeCycleDef != null ? this.addPhase(phaseDefinition, startDate, endDate) : this.addCustomPhase(existingPhase.getLabel(), startDate, endDate);
                phase.setListenerClassName(existingPhase.getListenerClassName());
                finalEndDate = endDate;
            } else if (lifeCycleDef != null) {
                this.addPhase(phaseDefinition, startDate);
            } else {
                this.addCustomPhase(existingPhase.getLabel(), startDate, null);
            }
            existingPhase.delete();
        }
        this.setStartDate(new Date());
        this.setEndDate(finalEndDate);
    }
}

