/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.lifecycle;

import com.arsdigita.cms.lifecycle.Lifecycle;
import com.arsdigita.cms.lifecycle.Phase;
import com.arsdigita.cms.lifecycle.PhaseDefinition;
import com.arsdigita.cms.lifecycle.PhaseDefinitionCollection;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataAssociationCursor;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.log4j.Logger;

public class LifecycleDefinition
extends ACSObject {
    private static Logger s_log = Logger.getLogger(LifecycleDefinition.class);
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.LifecycleDefinition";
    protected static final String LABEL = "label";
    protected static final String DESCRIPTION = "description";
    protected static final String DEFAULT_LISTENER = "defaultListener";
    protected static final String PHASE_DEFINITIONS = "phaseDefinitions";

    public LifecycleDefinition() {
        super(BASE_DATA_OBJECT_TYPE);
    }

    public LifecycleDefinition(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public LifecycleDefinition(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public LifecycleDefinition(DataObject obj) {
        super(obj);
    }

    protected LifecycleDefinition(String type) {
        super(type);
    }

    public String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public String getLabel() {
        return (String)this.get(LABEL);
    }

    public void setLabel(String label) {
        this.set(LABEL, label);
    }

    public String getDescription() {
        return (String)this.get(DESCRIPTION);
    }

    public void setDescription(String description) {
        this.set(DESCRIPTION, description);
    }

    public String getDefaultListener() {
        return (String)this.get(DEFAULT_LISTENER);
    }

    public void setDefaultListener(String listener) {
        this.set(DEFAULT_LISTENER, listener);
    }

    public PhaseDefinition addPhaseDefinition() {
        return this.addPhaseDefinition("Phase", null, null, null, null);
    }

    public PhaseDefinition addPhaseDefinition(String label, String description, Integer delay, Integer duration, String defaultListener) {
        PhaseDefinition pd = new PhaseDefinition();
        pd.setLifecycleDefinition(this);
        pd.setLabel(label);
        if (description != null) {
            pd.setDescription(description);
        }
        if (delay != null) {
            pd.setDefaultDelay(delay);
        }
        if (duration != null) {
            pd.setDefaultDuration(duration);
        }
        if (defaultListener != null) {
            pd.setDefaultListener(defaultListener);
        }
        return pd;
    }

    public PhaseDefinitionCollection getPhaseDefinitions() {
        DataAssociationCursor dac = ((DataAssociation)this.get(PHASE_DEFINITIONS)).cursor();
        return new PhaseDefinitionCollection((DataCollection)dac);
    }

    public Lifecycle createLifecycle() {
        Lifecycle lifecycle = new Lifecycle();
        lifecycle.setLifecycleDefinition(this);
        lifecycle.setListenerClassName(this.getDefaultListener());
        return lifecycle;
    }

    public Lifecycle createFullLifecycle(Date startDate, String listenerClassName) {
        if (startDate == null) {
            startDate = new Date();
        }
        Lifecycle lifecycle = this.createLifecycle();
        lifecycle.setListenerClassName(listenerClassName);
        lifecycle.save();
        PhaseDefinitionCollection phaseDefs = this.getPhaseDefinitions();
        while (phaseDefs.next()) {
            PhaseDefinition phaseDef = phaseDefs.getPhaseDefinition();
            Integer delay = phaseDef.getDefaultDelay();
            Integer duration = phaseDef.getDefaultDuration();
            Phase phase = lifecycle.addPhase(phaseDef);
            long begin = startDate.getTime() + delay.longValue() * 60L * 1000L;
            phase.setStartDate(new Date(begin));
            if (duration != null) {
                long end = begin + duration.longValue() * 60L * 1000L;
                phase.setEndDate(new Date(end));
            }
            phase.save();
        }
        lifecycle.save();
        return lifecycle;
    }

    public Lifecycle createFullLifecycle(String listenerClassName) {
        return this.createFullLifecycle(null, listenerClassName);
    }
}

