/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.lifecycle;

import com.arsdigita.cms.lifecycle.Lifecycle;
import com.arsdigita.db.Sequences;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.UncheckedWrapperException;
import java.math.BigDecimal;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class LifecycleService
extends DomainObject {
    private static final Logger s_log = Logger.getLogger(LifecycleService.class);
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.LifecycleService";
    public static final String SERVICE_ID = "serviceID";
    public static final String OBJECT_ID = "objectId";
    public static final String LIFECYCLE_ID = "lifecycle.id";
    public static final String LIFECYCLE = "lifecycle";
    public static final String ITEM = "item";
    public static final String ITEM_ID = "item.id";
    private Lifecycle m_lifecycleToDelete = null;

    protected LifecycleService() {
        super(BASE_DATA_OBJECT_TYPE);
    }

    protected LifecycleService(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    protected LifecycleService(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    protected LifecycleService(DataObject obj) {
        super(obj);
    }

    protected void initialize() {
        super.initialize();
        if (this.isNew()) {
            try {
                this.set(SERVICE_ID, Sequences.getNextValue());
            }
            catch (SQLException se) {
                throw new UncheckedWrapperException("Could not get sequence value", (Throwable)se);
            }
        }
    }

    protected BigDecimal getACSObjectID() {
        DataObject dobj = (DataObject)this.get(ITEM);
        if (dobj != null) {
            return (BigDecimal)dobj.get("id");
        }
        return null;
    }

    protected ACSObject getACSObject() {
        DataObject dobj = (DataObject)this.get(ITEM);
        if (dobj != null) {
            return (ACSObject)DomainObjectFactory.newInstance((DataObject)dobj);
        }
        return null;
    }

    protected void setACSObject(ACSObject object) {
        this.setAssociation(ITEM, (DomainObject)object);
    }

    protected BigDecimal getLifecycleID() {
        DataObject dobj = (DataObject)this.get(LIFECYCLE);
        if (dobj != null) {
            return (BigDecimal)dobj.get("id");
        }
        return null;
    }

    protected Lifecycle getLifecycle() {
        DataObject dobj = (DataObject)this.get(LIFECYCLE);
        if (dobj != null) {
            return new Lifecycle(dobj);
        }
        return null;
    }

    protected void setLifecycle(Lifecycle lifecycle) {
        this.setAssociation(LIFECYCLE, (DomainObject)lifecycle);
    }

    public static boolean setLifecycle(ACSObject obj, Lifecycle cycle) {
        LifecycleService service = LifecycleService.getLifecycleService(obj);
        boolean value = true;
        if (service == null) {
            service = new LifecycleService();
            service.setACSObject(obj);
            value = false;
        }
        service.setLifecycle(cycle);
        service.save();
        return value;
    }

    public static Lifecycle getLifecycle(ACSObject object) {
        LifecycleService service = LifecycleService.getLifecycleService(object);
        if (service != null) {
            return service.getLifecycle();
        }
        return null;
    }

    protected static LifecycleService getLifecycleService(ACSObject object) {
        DataCollection coll = SessionManager.getSession().retrieve(BASE_DATA_OBJECT_TYPE);
        coll.addEqualsFilter(ITEM_ID, (Object)object.getID());
        LifecycleService service = null;
        if (coll.next()) {
            service = new LifecycleService(coll.getDataObject());
            if (coll.next()) {
                s_log.warn((Object)("Multiple lifecycles for " + object.getOID().toString()));
            }
        }
        coll.close();
        return service;
    }

    public static boolean removeLifecycle(ACSObject object) {
        LifecycleService service = LifecycleService.getLifecycleService(object);
        if (service != null) {
            service.delete();
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Removed LifecycleService for object: " + object));
            }
            return true;
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("No LifecycleService to remove for object: " + object));
        }
        return false;
    }

    protected void beforeDelete() {
        super.beforeDelete();
        Lifecycle lifecycle = this.getLifecycle();
        if (lifecycle != null) {
            DataCollection coll = SessionManager.getSession().retrieve(BASE_DATA_OBJECT_TYPE);
            coll.addEqualsFilter(LIFECYCLE_ID, (Object)lifecycle.getID());
            coll.addNotEqualsFilter(SERVICE_ID, (Object)((BigDecimal)this.get(SERVICE_ID)));
            boolean foundReference = false;
            if (coll.next()) {
                foundReference = true;
            }
            coll.close();
            if (!foundReference) {
                this.m_lifecycleToDelete = lifecycle;
            }
        }
    }

    protected void afterDelete() {
        if (this.m_lifecycleToDelete != null) {
            this.m_lifecycleToDelete.delete();
        }
        super.afterDelete();
    }
}

