/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.lifecycle;

import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentPage;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.lifecycle.LifecycleEvent;
import com.arsdigita.cms.lifecycle.LifecycleListener;
import com.arsdigita.cms.ui.ContentItemPage;
import com.arsdigita.dispatcher.DispatcherHelper;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.Group;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.Role;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.UserCollection;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.messaging.Message;
import com.arsdigita.notification.Notification;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.FilterFactory;
import com.arsdigita.persistence.OID;
import com.arsdigita.util.Assert;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.web.URL;
import com.arsdigita.workflow.simple.UserTask;
import java.text.DateFormat;
import org.apache.log4j.Logger;

public class NotifyLifecycleListener
implements LifecycleListener {
    private static final Logger s_log = Logger.getLogger(NotifyLifecycleListener.class);
    private static final String ALERT_RECIPIENT_ROLE = "Alert Recipient";

    @Override
    public void begin(LifecycleEvent event) {
        s_log.debug((Object)"Beginning listener action");
        if (event.getEventType() != 0) {
            s_log.error((Object)"NotifyLifecycleListener called for  LifecycleEvent.LIFECYCLE event, but this class only handles LifecycleEvent.PHASE events!");
            return;
        }
        ContentItem item = this.getContentItem(event.getOID());
        ContentSection section = item.getContentSection();
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("item = " + (item == null ? "null" : item.toString())));
            s_log.debug((Object)("section = " + (section == null ? "null" : section.toString())));
        }
        Assert.exists((Object)item);
        Assert.exists((Object)((Object)section));
        UserCollection spamVictims = this.getRecipients(item);
        User user = null;
        Message message = this.createMessage(item, event);
        if (message != null) {
            if (spamVictims != null) {
                while (spamVictims.next()) {
                    user = (User)spamVictims.getDomainObject();
                    this.sendOneEmail(user, message);
                }
            } else {
                s_log.debug((Object)"No non-author users to notify");
            }
            if (ContentSection.getConfig().getNotifyAuthorOnLifecycle()) {
                User author = item.getCreationUser();
                if (author != null) {
                    this.sendOneEmail(author, message);
                } else {
                    s_log.debug((Object)"No author user to notify");
                }
            }
        } else {
            s_log.debug((Object)"No message to send");
        }
    }

    public void sendOneEmail(User user, Message message) {
        Notification notif = new Notification((Party)user, message);
        if (ContentSection.getConfig().deleteExpiryNotifications()) {
            notif.setIsPermanent(Boolean.FALSE);
            notif.setMessageDelete(Boolean.TRUE);
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("notifying user " + user.getPrimaryEmail()));
        }
    }

    @Override
    public void end(LifecycleEvent event) {
    }

    private ContentItem getContentItem(OID oid) {
        s_log.debug((Object)"getting content item");
        ContentItem item = null;
        try {
            item = (ContentItem)DomainObjectFactory.newInstance((OID)oid);
        }
        catch (DataObjectNotFoundException e) {
            e.printStackTrace();
            throw new UncheckedWrapperException((Throwable)e);
        }
        return item;
    }

    protected UserCollection getRecipients(ContentItem item) {
        ContentSection section = item.getContentSection();
        Group alertsGroup = section.getStaffGroup();
        Role alertRole = alertsGroup.getRole(ALERT_RECIPIENT_ROLE);
        UserCollection usersToAlert = null;
        if (alertRole != null) {
            usersToAlert = alertRole.getContainedUsers();
            Filter pFilter = PermissionService.getObjectFilterQuery((FilterFactory)usersToAlert.getFilterFactory(), (String)"id", (PrivilegeDescriptor)PrivilegeDescriptor.get((String)"cms_edit_item"), (OID)item.getDraftVersion().getParent().getOID());
            usersToAlert.addFilter(pFilter);
        }
        return usersToAlert;
    }

    protected Message createMessage(ContentItem item, LifecycleEvent lc) {
        Assert.exists((Object)item);
        Message message = null;
        Party sender = UserTask.getAlertsSender();
        if (sender == null) {
            s_log.error((Object)"Failed to get 'from' party from UserTask ");
        } else {
            ContentSection section = item.getContentSection();
            DateFormat df = DateFormat.getDateInstance(1);
            String name = null;
            name = item instanceof ContentPage ? ((ContentPage)item).getTitle() : item.getName();
            String subject = "Content Item " + name + " is about to expire";
            String publicURL = URL.there((String)(section.getSiteNode().getURL(DispatcherHelper.getWebappContext()) + ((ContentItem)item.getParent()).getPath()), null).getURL();
            ContentItem adminItem = item.getDraftVersion();
            if (adminItem == null) {
                adminItem = item;
            }
            String adminURL = URL.there((String)ContentItemPage.getItemURL(adminItem, ContentItemPage.AUTHORING_TAB), null).getURL();
            StringBuffer body = new StringBuffer(300);
            body.append("Content Item ");
            body.append(name);
            body.append(" at URL \n");
            body.append(publicURL);
            body.append(" is going to expire at ");
            body.append(df.format(lc.getEndDate()));
            body.append("\nAccess item administration here: ");
            body.append(adminURL);
            message = new Message(sender, subject, body.toString());
        }
        return message;
    }
}

