/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.lifecycle;

import com.arsdigita.cms.lifecycle.Lifecycle;
import com.arsdigita.cms.lifecycle.LifecycleEvent;
import com.arsdigita.cms.lifecycle.LifecycleListener;
import com.arsdigita.cms.lifecycle.PhaseDefinition;
import com.arsdigita.cms.lifecycle.PhaseDefinitionCollection;
import com.arsdigita.cms.lifecycle.PublishingException;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.log4j.Logger;

public class Phase
extends ACSObject {
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.Phase";
    public static final String LABEL = "label";
    public static final String START_DATE_TIME = "startDateTime";
    public static final String END_DATE_TIME = "endDateTime";
    public static final String LISTENER = "listener";
    public static final String HAS_BEGUN = "hasBegun";
    public static final String HAS_ENDED = "hasEnded";
    public static final String LIFECYCLE = "lifecycle";
    public static final String DEFINITION = "definition";
    private static final String PHASE_ID = "phaseId";
    private static final String OBJECT_ID = "objectId";
    private static final String OBJECT_TYPE = "objectType";
    private static final Logger s_log = Logger.getLogger(Phase.class);
    private PhaseDefinition m_definition = null;
    private boolean m_updateCycleTimes = true;

    protected Phase() {
        super(BASE_DATA_OBJECT_TYPE);
    }

    protected void initialize() {
        super.initialize();
        if (this.isNew()) {
            this.set(HAS_BEGUN, Boolean.FALSE);
            this.set(HAS_ENDED, Boolean.FALSE);
            this.setStartDate(new Date());
        }
    }

    public Phase(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public Phase(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public Phase(DataObject obj) {
        super(obj);
    }

    protected Phase(String type) {
        super(type);
    }

    public String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public String getLabel() {
        PhaseDefinition definition = this.getPhaseDefinition();
        if (definition == null) {
            return "No Label";
        }
        return definition.getLabel();
    }

    public Date getStartDate() {
        return (Date)this.get(START_DATE_TIME);
    }

    public void setStartTime(Long time) {
        if (time == null) {
            this.setStartDate(null);
        } else {
            this.setStartDate(new Date(time));
        }
    }

    public void setStartDate(Date date) {
        this.set(START_DATE_TIME, date);
    }

    public Date getEndDate() {
        return (Date)this.get(END_DATE_TIME);
    }

    public void setEndTime(Long time) {
        if (time == null) {
            this.setEndDate(null);
        } else {
            this.setEndDate(new Date(time));
        }
    }

    public void setEndDate(Date date) {
        this.set(END_DATE_TIME, date);
    }

    public String getListenerClassName() {
        return (String)this.get(LISTENER);
    }

    public LifecycleListener getListener() {
        String listenerClassName = this.getListenerClassName();
        LifecycleListener listener = null;
        if (listenerClassName != null) {
            try {
                Class<?> listenerClass = Class.forName(listenerClassName);
                listener = (LifecycleListener)listenerClass.newInstance();
            }
            catch (Exception e) {
                s_log.error((Object)"Listener instantiation error", (Throwable)e);
                throw new PublishingException("Error instantiating lifecycle listener: " + listenerClassName, e);
            }
        }
        return listener;
    }

    public void setListenerClassName(String listener) {
        this.set(LISTENER, listener);
    }

    public boolean hasBegun() {
        return (Boolean)this.get(HAS_BEGUN);
    }

    protected void setHasBegun(boolean hasBegun) {
        this.set(HAS_BEGUN, new Boolean(hasBegun));
    }

    public boolean hasEnded() {
        return (Boolean)this.get(HAS_ENDED);
    }

    public Lifecycle getLifecycle() {
        DataObject lifecycle = (DataObject)this.get(LIFECYCLE);
        if (lifecycle == null) {
            return null;
        }
        return new Lifecycle(lifecycle);
    }

    protected void setLifecycle(Lifecycle lifecycle) {
        this.setAssociation(LIFECYCLE, (DomainObject)lifecycle);
    }

    public PhaseDefinition getPhaseDefinition() {
        DataObject definition = (DataObject)this.get(DEFINITION);
        if (definition == null) {
            return null;
        }
        return new PhaseDefinition(definition);
    }

    protected void setPhaseDefinition(PhaseDefinition definition) {
        this.setAssociation(DEFINITION, (DomainObject)definition);
    }

    public void delete(boolean updateCycleTimes) {
        this.m_updateCycleTimes = updateCycleTimes;
        this.delete();
    }

    public void beforeDelete() {
        s_log.debug((Object)("About to delete phase " + this.getID()));
        super.beforeDelete();
        Lifecycle cycle = this.getLifecycle();
        if (cycle != null) {
            PhaseDefinition definition = this.getPhaseDefinition();
            PhaseDefinitionCollection cyclePhaseDefinitions = cycle.getLifecycleDefinition().getPhaseDefinitions();
            cyclePhaseDefinitions.addEqualsFilter("id", definition.getID());
            if (cyclePhaseDefinitions.isEmpty()) {
                s_log.debug((Object)("Phase Definition " + definition.getID() + ": " + definition.getLabel() + " is a custom phase definition. I will delete it after deleting phase " + this.getID()));
                this.m_definition = definition;
            }
        }
    }

    public void delete() {
        Lifecycle cycle = this.getLifecycle();
        super.delete();
        if (cycle != null && this.m_updateCycleTimes) {
            cycle.updateStartEndTimes();
        }
    }

    public void afterDelete() {
        if (this.m_definition != null) {
            this.m_definition.delete();
        }
    }

    protected void afterSave() {
        super.afterSave();
        Lifecycle cycle = this.getLifecycle();
        if (cycle != null) {
            cycle.updateStartEndTimes();
        }
    }

    public void start() {
        if (!this.hasBegun()) {
            Date now = new Date();
            Date startDate = this.getStartDate();
            if (startDate == null) {
                startDate = now;
            }
            if (startDate.before(now) || startDate.equals(now)) {
                this.fireListeners();
            }
        }
    }

    private void fireListeners() {
        LifecycleListener listener = this.getListener();
        if (listener != null) {
            Session ssn = SessionManager.getSession();
            DataQuery dq = ssn.retrieveQuery("com.arsdigita.cms.getObjectPhaseMappings");
            Filter f = dq.addEqualsFilter(PHASE_ID, (Object)this.getID());
            while (dq.next()) {
                BigDecimal objectId = (BigDecimal)dq.get(OBJECT_ID);
                String objectType = (String)dq.get(OBJECT_TYPE);
                LifecycleEvent event = new LifecycleEvent(0, this.getStartDate(), this.getEndDate(), objectType, objectId);
                try {
                    listener.begin(event);
                    this.setHasBegun(true);
                    this.save();
                }
                catch (Exception e) {
                    s_log.error((Object)"Error firing listeners", (Throwable)e);
                    dq.close();
                    throw new PublishingException(e.getMessage());
                }
            }
        }
    }

    protected void stop() {
        this.set(HAS_ENDED, Boolean.TRUE);
    }
}

