/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.lifecycle;

import com.arsdigita.cms.ContentBundle;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.lifecycle.LifecycleEvent;
import com.arsdigita.cms.lifecycle.LifecycleListener;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.persistence.OID;
import com.arsdigita.util.Assert;
import org.apache.log4j.Logger;

public class PublishLifecycleListener
implements LifecycleListener {
    private static final Logger s_log = Logger.getLogger(PublishLifecycleListener.class);

    @Override
    public void begin(LifecycleEvent event) {
        s_log.info((Object)("PublishLifecycleListener begin is called. \n" + event.toString() + "\n" + event.getOID().toString()));
        ContentItem item = this.getContentItem(event.getOID());
        if (Assert.isEnabled()) {
            Assert.isFalse((boolean)(item instanceof ContentBundle), (String)"Content bundles cannot be published");
        }
        ContentItem master = null;
        ContentItem pending = null;
        if (item.isDraftVersion()) {
            master = item;
            pending = master.getPublicVersion();
            if (Assert.isEnabled()) {
                Assert.isEqual((Object)"pending", (Object)pending.getVersion());
            }
        } else {
            pending = item;
            master = pending.getDraftVersion();
            Assert.isNotEqual((Object)master, (Object)pending);
            Assert.isEqual((Object)"draft", (Object)master.getVersion());
        }
        master.promotePendingVersion(pending);
    }

    @Override
    public void end(LifecycleEvent event) {
        s_log.info((Object)("PublishLifecycleListener end is called. \n" + event.toString() + "\n" + event.getOID().toString()));
        ContentItem item = this.getContentItem(event.getOID());
        ContentItem master = null;
        master = item.isLiveVersion() ? item.getWorkingVersion() : item;
        if (master.isLive()) {
            master.setLive(null);
        }
    }

    private ContentItem getContentItem(OID oid) {
        ContentItem item = (ContentItem)DomainObjectFactory.newInstance((OID)oid);
        return item;
    }
}

