/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.portlet;

import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.portal.AbstractPortletRenderer;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ui.portlet.ContentItemPortletEditor;
import com.arsdigita.cms.ui.portlet.ContentItemPortletRenderer;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.domain.DomainObjectInstantiator;
import com.arsdigita.kernel.ACSObjectInstantiator;
import com.arsdigita.kernel.ResourceType;
import com.arsdigita.kernel.ResourceTypeConfig;
import com.arsdigita.kernel.ui.ResourceConfigFormSection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.portal.Portlet;
import com.arsdigita.portal.PortletType;
import org.apache.log4j.Logger;

public class ContentItemPortlet
extends Portlet {
    private static final Logger s_log = Logger.getLogger(ContentItemPortlet.class);
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.portlet.ContentItemPortlet";
    public static final String ITEM = "item";

    public ContentItemPortlet(DataObject dataObject) {
        super(dataObject);
    }

    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public ContentItem getContentItem() {
        return (ContentItem)DomainObjectFactory.newInstance((DataObject)((DataObject)this.get(ITEM)));
    }

    public void setContentItem(ContentItem item) {
        this.setAssociation(ITEM, (DomainObject)item);
    }

    public AbstractPortletRenderer doGetPortletRenderer() {
        return new ContentItemPortletRenderer(this);
    }

    public static void loadPortletType() {
        PortletType type = PortletType.createPortletType((String)"Content Item", (String)"wide", (String)BASE_DATA_OBJECT_TYPE);
        type.setDescription("Displays the body of a content item");
        s_log.info((Object)("Loading portlet type " + type));
    }

    public static void initPortlet() {
        DomainObjectFactory.registerInstantiator((String)BASE_DATA_OBJECT_TYPE, (DomainObjectInstantiator)new ACSObjectInstantiator(){

            public DomainObject doNewInstance(DataObject dataObject) {
                return new ContentItemPortlet(dataObject);
            }
        });
        new ResourceTypeConfig(BASE_DATA_OBJECT_TYPE){

            public ResourceConfigFormSection getCreateFormSection(ResourceType resType, RequestLocal parentAppRL) {
                return new ContentItemPortletEditor(resType, parentAppRL);
            }

            public ResourceConfigFormSection getModifyFormSection(RequestLocal application) {
                return new ContentItemPortletEditor(application);
            }
        };
    }
}

