/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.portlet;

import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.portal.AbstractPortletRenderer;
import com.arsdigita.cms.ui.portlet.TaskPortletEditor;
import com.arsdigita.cms.ui.portlet.TaskPortletRenderer;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.domain.DomainObjectInstantiator;
import com.arsdigita.kernel.ACSObjectInstantiator;
import com.arsdigita.kernel.ResourceType;
import com.arsdigita.kernel.ResourceTypeConfig;
import com.arsdigita.kernel.ui.ResourceConfigFormSection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.portal.Portlet;
import com.arsdigita.portal.PortletSetup;
import com.arsdigita.portal.PortletType;
import org.apache.log4j.Category;
import org.apache.log4j.Logger;

public class TaskPortlet
extends Portlet {
    private static final Logger s_log = Logger.getLogger(TaskPortlet.class);
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.portlet.TaskPortlet";

    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public TaskPortlet(DataObject dataObject) {
        super(dataObject);
    }

    public int getMaxNumTasks() {
        return (Integer)this.get("numTasks");
    }

    public void setMaxNumTasks(int taskCount) {
        this.set("numTasks", new Integer(taskCount));
    }

    protected AbstractPortletRenderer doGetPortletRenderer() {
        return new TaskPortletRenderer(this);
    }

    public static void loadPortletType() {
        PortletType type = PortletType.createPortletType((String)"Task Portlet", (String)"wide", (String)BASE_DATA_OBJECT_TYPE);
        type.setDescription("Displays a Task List");
        s_log.info((Object)("Loading portlet type " + type));
    }

    public static void initPortlet() {
        DomainObjectFactory.registerInstantiator((String)BASE_DATA_OBJECT_TYPE, (DomainObjectInstantiator)new ACSObjectInstantiator(){

            public DomainObject doNewInstance(DataObject dataObject) {
                return new TaskPortlet(dataObject);
            }
        });
        new ResourceTypeConfig(BASE_DATA_OBJECT_TYPE){

            public ResourceConfigFormSection getCreateFormSection(ResourceType resType, RequestLocal parentAppRL) {
                return new TaskPortletEditor(resType, parentAppRL);
            }

            public ResourceConfigFormSection getModifyFormSection(RequestLocal application) {
                return new TaskPortletEditor(application);
            }
        };
    }

    public void loadTaskPortlet() {
        PortletSetup setup = new PortletSetup((Category)s_log);
        setup.setPortletObjectType(BASE_DATA_OBJECT_TYPE);
        setup.setTitle("Task Portlet");
        setup.setDescription("Displays a Task List");
        setup.setProfile("wide");
        setup.setInstantiator((DomainObjectInstantiator)new ACSObjectInstantiator(){

            protected DomainObject doNewInstance(DataObject dataObject) {
                return new TaskPortlet(dataObject);
            }
        });
        setup.run();
        new ResourceTypeConfig(BASE_DATA_OBJECT_TYPE){

            public ResourceConfigFormSection getCreateFormSection(ResourceType resType, RequestLocal parentAppRL) {
                TaskPortletEditor config = new TaskPortletEditor(resType, parentAppRL);
                return config;
            }

            public ResourceConfigFormSection getModifyFormSection(RequestLocal application) {
                TaskPortletEditor config = new TaskPortletEditor(application);
                return config;
            }
        };
    }
}

