/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.publishToFile;

import com.arsdigita.cms.publishToFile.LocalRequestPassword;
import com.arsdigita.cms.publishToFile.PublishToFileException;
import com.arsdigita.cms.publishToFile.PublishedHTMLProvider;
import com.arsdigita.cms.publishToFile.RetrievedFile;
import com.arsdigita.cms.publishToFile.SetLocalRequestPassword;
import com.arsdigita.util.Assert;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.log4j.Logger;
import sun.net.www.protocol.http.HttpURLConnection;

class HttpHTMLProvider
implements PublishedHTMLProvider,
SetLocalRequestPassword {
    private static final Logger s_log = Logger.getLogger(HttpHTMLProvider.class);
    private final int m_timeout;

    HttpHTMLProvider(int timeout) {
        Assert.isTrue((timeout > 0 ? 1 : 0) != 0, (String)"Timeout must be > than 0.");
        this.m_timeout = timeout;
    }

    @Override
    public RetrievedFile fetchHTML(String urlSource) {
        StringBuffer buffer = new StringBuffer(256);
        String contentType = "";
        boolean contentLength = false;
        URL url = null;
        try {
            url = new URL(urlSource);
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("urlsource is " + urlSource));
                s_log.debug((Object)("url protocol is " + url.getProtocol()));
                s_log.debug((Object)("url host is " + url.getHost()));
                s_log.debug((Object)("url port is " + url.getPort()));
                s_log.debug((Object)("url path is " + url.getPath()));
            }
            HttpURLConnection con = new HttpURLConnection(url, url.getHost(), url.getPort());
            this.setPassword(con);
            con.connect();
            contentType = con.getHeaderField("Content-Type");
            int status = con.getResponseCode();
            if (200 != status) {
                throw new PublishToFileException("Bad response code " + status + " when reading " + urlSource);
            }
            s_log.debug((Object)"Opening input from connection...");
            BufferedReader input = new BufferedReader(new InputStreamReader(con.getInputStream()));
            ReadConnection rc = new ReadConnection(input, buffer);
            rc.start();
            try {
                rc.join(1000 * this.m_timeout);
            }
            catch (InterruptedException ie) {
                s_log.warn((Object)"Publishing thread interrupted when reading html: ", (Throwable)ie);
            }
            if (rc.isAlive()) {
                rc.interrupt();
                con.disconnect();
                throw new PublishToFileException("Timeout when reading html: " + urlSource);
            }
            input.close();
        }
        catch (MalformedURLException mal) {
            throw new PublishToFileException("Malformed URL: " + url, mal);
        }
        catch (IOException io) {
            throw new PublishToFileException("IO Error when reading html from: " + url, io);
        }
        return new RetrievedFile(buffer.toString(), contentType);
    }

    @Override
    public void setPassword(URLConnection con) {
        LocalRequestPassword.setLocalRequestPassword(con);
    }

    private final class ReadConnection
    extends Thread {
        private StringBuffer buffer;
        private BufferedReader input;

        ReadConnection(BufferedReader input, StringBuffer buffer) {
            this.buffer = buffer;
            this.input = input;
        }

        @Override
        public void run() {
            this.setName("Read HTML");
            String line = null;
            try {
                while ((line = this.input.readLine()) != null) {
                    this.buffer.append(line).append('\n');
                }
            }
            catch (IOException io) {
                s_log.error((Object)"IO Error when reading html: ", (Throwable)io);
            }
        }
    }
}

