/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.publishToFile;

import com.arsdigita.cms.publishToFile.DestinationStub;
import com.arsdigita.cms.publishToFile.PublishToFile;
import com.arsdigita.cms.publishToFile.PublishToFileConfig;
import com.arsdigita.cms.publishToFile.PublishToFileListener;
import com.arsdigita.cms.publishToFile.PublishedFile;
import com.arsdigita.cms.publishToFile.QueueManager;
import com.arsdigita.db.DbHelper;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.domain.DomainObjectInstantiator;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.metadata.MetadataRoot;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.runtime.CCMResourceManager;
import com.arsdigita.runtime.CompoundInitializer;
import com.arsdigita.runtime.ConfigError;
import com.arsdigita.runtime.ContextCloseEvent;
import com.arsdigita.runtime.ContextInitEvent;
import com.arsdigita.runtime.DomainInitEvent;
import com.arsdigita.runtime.RuntimeConfig;
import com.arsdigita.util.UncheckedWrapperException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class Initializer
extends CompoundInitializer {
    private static Logger s_log = Logger.getLogger(Initializer.class);
    private static PublishToFileConfig s_conf = PublishToFileConfig.getConfig();

    public Initializer() {
        String url = RuntimeConfig.getConfig().getJDBCURL();
        int database = DbHelper.getDatabaseFromURL((String)url);
    }

    public void init(DomainInitEvent e) {
        s_log.debug((Object)"publishToFile.Initializer.init(DomainInitEvent) invoked");
        super.init(e);
        e.getFactory();
        DomainObjectFactory.registerInstantiator((String)"com.arsdigita.cms.publishToFile.PublishedFile", (DomainObjectInstantiator)new DomainObjectInstantiator(){

            public DomainObject doNewInstance(DataObject dataObject) {
                return new PublishedFile(dataObject);
            }

            public DomainObjectInstantiator resolveInstantiator(DataObject obj) {
                return this;
            }
        });
        Initializer.processDestination((ArrayList)s_conf.getPublishDestinations());
    }

    public void init(ContextInitEvent evt) {
        s_log.debug((Object)"publishToFile.Initializer.init(ContextInitEvent) invoked");
        super.init(evt);
        PublishToFile.setRequestTimeout(s_conf.getRequestTimeout());
        QueueManager.setRetryDelay(s_conf.getRetryDelay());
        QueueManager.setBlockSize(s_conf.getBlockSize());
        QueueManager.setBlockSelectMethod(s_conf.getBlockSelectMethod());
        QueueManager.setMaximumFailCount(s_conf.getMaximumFailCount());
        try {
            QueueManager.setListener((PublishToFileListener)s_conf.getPublishListenerClass().newInstance());
        }
        catch (InstantiationException ex) {
            throw new UncheckedWrapperException("Failed to instantiate the listener class", (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            throw new UncheckedWrapperException("Couldn't access the listener class", (Throwable)ex);
        }
        QueueManager.startWatchingQueue(s_conf.getStartupDelay(), s_conf.getPollDelay());
        QueueManager.requeueMissingFiles();
        s_log.debug((Object)"publishToFile.Initializer.init(ContextInitEvent) completed");
    }

    public void close(ContextCloseEvent evt) {
        s_log.debug((Object)"publishToFile.Initializer.destroy() invoked");
        QueueManager.stopWatchingQueue();
        s_log.debug((Object)"publishToFile.Initializer.destroy() completed");
    }

    private static void processDestination(ArrayList dest) throws ConfigError {
        if (dest == null) {
            throw new ConfigError("publish destinations must not be null");
        }
        if (dest.size() < 1) {
            throw new ConfigError("publish destinations must contain at least one entry");
        }
        Iterator entries = dest.iterator();
        while (entries.hasNext()) {
            Initializer.processDestinationEntry((List)entries.next());
        }
    }

    private static void processDestinationEntry(List entry) throws ConfigError {
        File conf;
        if (entry.size() != 4) {
            throw new ConfigError("publish destinations entry must contain four elements: '{ \n  \"content type\",\n  \"root directory\", \n  \"is shared\", \n  \"url stub\" \n};\n");
        }
        String contentType = (String)entry.get(0);
        String destRoot = (String)entry.get(1);
        Boolean sharedRoot = (Boolean)entry.get(2);
        String destURL = (String)entry.get(3);
        if (contentType == null || contentType.trim().length() == 0) {
            throw new ConfigError("The destination content type must not be null");
        }
        ObjectType type = MetadataRoot.getMetadataRoot().getObjectType(contentType);
        if (type == null) {
            throw new ConfigError("The destination content type cannot be found");
        }
        if (destRoot == null || destRoot.trim().length() == 0) {
            throw new ConfigError("The destination root must not be null");
        }
        if (destRoot.endsWith("/")) {
            throw new ConfigError("the destination root '" + destRoot + "' must not end with a '/'");
        }
        destRoot = new File(CCMResourceManager.getBaseDirectory().getPath(), destRoot).getPath();
        s_log.info((Object)("Destination Root is set to : " + destRoot));
        if (sharedRoot == null) {
            throw new ConfigError("The destination shared flag must not be null");
        }
        if (destURL == null || "".equals(destURL.trim())) {
            throw new ConfigError("the destination URL must not be null");
        }
        if (!destURL.startsWith("/")) {
            throw new ConfigError("the destination URL '" + destURL + "' must start with a '/'");
        }
        if (destURL.endsWith("/")) {
            throw new ConfigError("the destination URL '" + destURL + "' must not end with a '/'");
        }
        DestinationStub dest = new DestinationStub(destRoot, sharedRoot, destURL);
        File file = dest.getFile();
        if (!file.exists()) {
            file.mkdirs();
            s_log.info((Object)(file.getPath() + " created"));
        }
        boolean writable = false;
        File fname = new File(file.getPath(), "placeholder.txt");
        s_log.info((Object)("Try to create : " + destRoot));
        try {
            writable = file.canWrite() && file.isDirectory();
            try {
                FileWriter fl = new FileWriter(fname.getPath());
                fl.write("Location for the p2fs module to store static content. \n");
                fl.close();
            }
            catch (IOException e) {
                s_log.warn((Object)("Error creating file " + fname.getPath()));
            }
        }
        catch (SecurityException ex) {
            // empty catch block
        }
        if (!(writable || (conf = CCMResourceManager.getConfigDirectory()).isDirectory() && conf.canWrite())) {
            throw new ConfigError(" the document root '" + file + "' must be a writable directory");
        }
        if ("com.arsdigita.cms.Template".equals(contentType) || !s_conf.isItemPfsDisabled()) {
            PublishToFile.addDestination(contentType, dest);
        }
    }
}

