/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.publishToFile;

import com.arsdigita.cms.publishToFile.PublishToFileException;
import com.arsdigita.cms.publishToFile.QueueEntry;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import java.math.BigDecimal;
import java.sql.SQLException;
import org.apache.log4j.Logger;

class PublishedLink
extends DomainObject {
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.publishToFile.PublishedLink";
    private static Logger s_log = Logger.getLogger((String)PublishedLink.class.getName());
    private static final String ID = "id";
    private static final String SOURCE = "source";
    private static final String TARGET = "target";
    private static final String IS_CHILD = "isChild";

    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public PublishedLink() {
        super(BASE_DATA_OBJECT_TYPE);
    }

    public PublishedLink(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public PublishedLink(DataObject dataObject) {
        super(dataObject);
    }

    static void saveLinkInfo(BigDecimal sourceId, BigDecimal targetId, boolean isChild) throws PublishToFileException {
        try {
            PublishedLink link = PublishedLink.alreadyHaveLink(sourceId, targetId);
            if (link == null) {
                link = new PublishedLink();
                BigDecimal id = QueueEntry.generateID();
                link.setId(id);
                link.setSource(sourceId);
                link.setTarget(targetId);
            } else {
                s_log.warn((Object)("Found previously existing link.  Source=" + sourceId + " target=" + targetId + " previous isChild=" + link.getIsChild() + " new isChild=" + isChild));
            }
            link.setIsChild(new Boolean(isChild));
            link.save();
        }
        catch (SQLException e) {
            throw new PublishToFileException("Unable to save PublishedLink:  sourceId=" + sourceId + " targetId=" + targetId + " error=" + e.getMessage());
        }
    }

    static PublishedLink alreadyHaveLink(BigDecimal sourceId, BigDecimal targetId) throws SQLException {
        PublishedLink link = null;
        DataQuery query = SessionManager.getSession().retrieveQuery("com.arsdigita.cms.publishToFile.checkIfAlreadyHaveLink");
        query.setParameter(SOURCE, (Object)sourceId);
        query.setParameter(TARGET, (Object)targetId);
        if (query.next()) {
            DataObject dobj = (DataObject)query.get("publishedLink");
            link = new PublishedLink(dobj);
        }
        query.close();
        return link;
    }

    public void setId(BigDecimal id) {
        this.set(ID, id);
    }

    public void setSource(BigDecimal source) {
        this.set(SOURCE, source);
    }

    public void setTarget(BigDecimal target) {
        this.set(TARGET, target);
    }

    public void setIsChild(Boolean isChild) {
        this.set(IS_CHILD, isChild);
    }

    public BigDecimal getId() {
        return (BigDecimal)this.get(ID);
    }

    public BigDecimal getSource() {
        return (BigDecimal)this.get(SOURCE);
    }

    public BigDecimal getTarget() {
        return (BigDecimal)this.get(TARGET);
    }

    public Boolean getIsChild() {
        return (Boolean)this.get(IS_CHILD);
    }
}

