/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.publishToFile;

import com.arsdigita.cms.ContentBundle;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.Folder;
import com.arsdigita.cms.publishToFile.DestinationStub;
import com.arsdigita.cms.publishToFile.PublishToFile;
import com.arsdigita.cms.publishToFile.PublishToFileException;
import com.arsdigita.cms.publishToFile.PublishToFileListener;
import com.arsdigita.cms.publishToFile.PublishedFile;
import com.arsdigita.cms.publishToFile.QueueEntry;
import com.arsdigita.cms.publishToFile.QueueEntryCollection;
import com.arsdigita.domain.DomainCollection;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataOperation;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.TransactionContext;
import com.arsdigita.util.Assert;
import com.arsdigita.web.Host;
import com.arsdigita.web.Web;
import java.io.File;
import java.math.BigDecimal;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class QueueManager
implements Runnable {
    private static Logger s_log = Logger.getLogger(QueueManager.class);
    private int m_startupDelay;
    private int m_pollDelay;
    static Integer s_retryDelay = new Integer(120);
    static Integer s_blockSize = new Integer(20);
    static String s_blockSelectMethod = "QueuedOrder";
    static Integer s_maximumFailCount = new Integer(-1);
    private static boolean s_keepWatchingQueue = true;
    private static Thread s_queueThread = null;
    private static PublishToFileListener s_publishListener = null;

    private QueueManager(int startupDelay, int pollDelay) {
        this.m_startupDelay = startupDelay;
        this.m_pollDelay = pollDelay;
    }

    public static void setRetryDelay(Integer delay) {
        s_retryDelay = delay;
    }

    public static void setBlockSize(Integer size) {
        s_blockSize = size;
    }

    static void setBlockSelectMethod(String method) {
        s_blockSelectMethod = method;
    }

    public static void setMaximumFailCount(Integer maxFailCount) {
        Assert.exists((Object)maxFailCount, Integer.class);
        s_maximumFailCount = maxFailCount;
    }

    public static void setListener(PublishToFileListener l) {
        s_publishListener = l;
    }

    public static void requeueMissingFiles() {
        DomainCollection files = PublishedFile.retrieveAll();
        HashSet<String> done = new HashSet<String>();
        while (files.next()) {
            ContentItem item;
            PublishedFile fileRecord = (PublishedFile)files.getDomainObject();
            if (done.contains(fileRecord.getFileName())) continue;
            done.add(fileRecord.getFileName());
            File file = fileRecord.getFile();
            if (file == null) {
                s_log.debug((Object)"Ignoring null file.");
                continue;
            }
            if (file.exists()) {
                if (!s_log.isDebugEnabled()) continue;
                s_log.debug((Object)("File " + file.getAbsolutePath() + " already exists"));
                continue;
            }
            if (s_log.isInfoEnabled()) {
                s_log.info((Object)("Published file " + file.getAbsolutePath() + " for item " + fileRecord.getItemId() + " isn't on the filesystem. Scheduling for " + "republishing."));
            }
            if ((item = fileRecord.getItem()) == null) {
                s_log.warn((Object)("No corresponding content item found for published file " + fileRecord.getFileName() + " " + "(draft id " + fileRecord.getDraftId() + ", " + "item id " + fileRecord.getItemId() + ")"));
                continue;
            }
            ACSObject parent = item.getParent();
            BigDecimal parentID = null;
            if (null != parent) {
                parentID = parent.getID();
            }
            QueueManager.queue(item, parentID, "republish", null, Web.getConfig().getCurrentHost());
        }
    }

    public static void queuePublish(ContentItem item) {
        Assert.isTrue((!(item instanceof ContentBundle) ? 1 : 0) != 0, (String)("Cannot queue content bundle " + item));
        Assert.isTrue((boolean)item.isLiveVersion(), (String)"Item is not live");
        if (s_log.isInfoEnabled()) {
            s_log.info((Object)("Queue publish task for " + item.getID()));
        }
        String task = "publish";
        QueueEntryCollection q = new QueueEntryCollection(item.getID());
        while (q.next()) {
            if (q.isPublishTask()) {
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)("Deleting existing publish task " + q.getID()));
                }
                q.delete();
                continue;
            }
            if (!q.isUnpublishTask() && !q.isRepublishTask()) continue;
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Deleting existing (un|re)publish task " + q.getID()));
            }
            task = "republish";
            q.delete();
        }
        QueueManager.queue(item, task);
    }

    public static void queueUnpublish(ContentItem item) {
        if (s_log.isInfoEnabled()) {
            s_log.info((Object)("Queue unpublish task for " + item.getID()));
        }
        QueueEntryCollection q = new QueueEntryCollection(item.getID());
        while (q.next()) {
            if (!q.isPublishTask() && !q.isRepublishTask() && !q.isUnpublishTask()) continue;
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Deleting existing (un|re|new)publish task " + q.getID()));
            }
            q.delete();
        }
        QueueManager.queue(item, "unpublish");
    }

    public static void queueRepublish(ContentItem item) {
        if (s_log.isInfoEnabled()) {
            s_log.info((Object)("Queue republish task for " + item.getID()));
        }
        QueueEntryCollection q = new QueueEntryCollection(item.getID());
        while (q.next()) {
            if (q.isUnpublishTask() || q.isPublishTask()) {
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)("Deleting existing (un|new)publish task " + q.getID()));
                }
                q.delete();
                continue;
            }
            if (!q.isRepublishTask()) continue;
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Aborting because there is already a republish " + q.getID()));
            }
            q.close();
            return;
        }
        QueueManager.queue(item, "republish");
    }

    public static void queueMoveTask(ContentItem liveItem, Folder source, Folder destination) {
        if (s_log.isInfoEnabled()) {
            s_log.info((Object)("Queue move task for " + liveItem.getID()));
        }
        Assert.isTrue((liveItem != null && liveItem.isLiveVersion() ? 1 : 0) != 0, (String)"Item is not live");
        Assert.isTrue((source != null && source.isLiveVersion() ? 1 : 0) != 0, (String)"Source is not live");
        Assert.isTrue((destination != null && destination.isLiveVersion() ? 1 : 0) != 0, (String)"Destination is not live");
        QueueManager.queue(liveItem, source.getID(), "move", destination.getID().toString());
    }

    private static void queue(ContentItem item, String task) {
        Assert.isTrue((!(item instanceof ContentBundle) ? 1 : 0) != 0, (String)("Cannot queue content bundle " + item));
        Assert.isTrue((boolean)item.isLiveVersion(), (String)"Item is not live");
        ACSObject parent = item.getParent();
        BigDecimal parentID = null;
        if (null != parent) {
            parentID = parent.getID();
        }
        QueueManager.queue(item, parentID, task, null);
    }

    private static void queue(ContentItem item, BigDecimal parentId, String task, String destination) {
        DestinationStub dest;
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Queue " + task + " for " + item.getOID() + " on all hosts"));
        }
        if ((dest = PublishToFile.getDestination(item.getSpecificObjectType())) == null) {
            return;
        }
        DomainCollection hosts = Host.retrieveAll();
        while (hosts.next()) {
            Host host = (Host)hosts.getDomainObject();
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Queue on " + host));
            }
            QueueEntry q = QueueEntry.create(item, parentId, task, host, destination);
            q.save();
        }
    }

    private static void queue(ContentItem item, BigDecimal parentId, String task, String destination, Host host) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Queue item " + item + " for " + task + " on " + host));
        }
        QueueEntry q = QueueEntry.create(item, parentId, task, host, destination);
        q.save();
    }

    public static void startWatchingQueue(int startupDelay, int pollDelay) {
        if (startupDelay > 0) {
            if (s_log.isInfoEnabled()) {
                s_log.info((Object)"Going to start queue processing.");
            }
            s_queueThread = new Thread(new QueueManager(startupDelay, pollDelay));
            s_queueThread.setDaemon(true);
            s_queueThread.setName("cms-p2fs-queue");
            s_queueThread.start();
            s_keepWatchingQueue = true;
        }
    }

    public static void stopWatchingQueue() {
        if (s_log.isInfoEnabled()) {
            s_log.info((Object)"Sending signal to stop queue processing.");
        }
        s_keepWatchingQueue = false;
    }

    @Override
    public void run() {
        s_log.info((Object)("Start polling queue in " + this.m_startupDelay + "s."));
        QueueManager.sleep(this.m_startupDelay);
        s_log.info((Object)("Polling queue every " + this.m_pollDelay + "s."));
        HashSet failedItems = new HashSet();
        while (QueueManager.sleep(this.m_pollDelay) && s_keepWatchingQueue) {
            while (QueueManager.processQueueItems(failedItems)) {
            }
            failedItems.clear();
        }
        s_log.info((Object)("Start polling queue in " + this.m_startupDelay + "s."));
    }

    private static boolean sleep(long n) {
        try {
            Thread.sleep(n * 1000L);
            return true;
        }
        catch (InterruptedException e) {
            s_log.error((Object)"Waiting was interrupted.");
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean processQueueItems(HashSet failedItems) {
        Session ssn = SessionManager.getSession();
        TransactionContext txn = ssn.getTransactionContext();
        boolean hasMore = false;
        Object query = null;
        try {
            txn.beginTxn();
            hasMore = QueueManager.processQueueItemsInternal(query, failedItems);
            txn.commitTxn();
            return hasMore;
        }
        catch (Exception e) {
            s_log.warn((Object)"Ignoring uncaught exception", (Throwable)e);
            return hasMore;
        }
        finally {
            try {
                try {
                    if (query != null) {
                        query.close();
                    }
                    if (txn.inTxn()) {
                        txn.abortTxn();
                        s_log.info((Object)"Aborting transaction");
                    }
                    query = null;
                }
                catch (Exception e) {
                    s_log.warn((Object)"Txn cleanup failed", (Throwable)e);
                    query = null;
                }
            }
            catch (Throwable throwable) {
                query = null;
                throw throwable;
            }
        }
    }

    private static boolean processQueueItemsInternal(DataQuery query, HashSet failedItems) {
        Host host = Web.getConfig().getCurrentHost();
        boolean hasMore = false;
        query = QueueManager.getBlockQuery();
        query.setParameter("hostId", (Object)host.getID());
        query.setParameter("queueEntryRetryDelay", (Object)s_retryDelay);
        query.setParameter("maximumFailCount", (Object)s_maximumFailCount);
        int entryCount = 0;
        while (query.next() && entryCount < s_blockSize) {
            BigDecimal itemId;
            DataObject dobj = (DataObject)query.get("queueEntry");
            QueueEntry qe = new QueueEntry(dobj);
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Processing queue entry " + (Object)((Object)qe)));
            }
            if (failedItems.contains(itemId = qe.getItemId())) continue;
            try {
                if (entryCount == 0) {
                    s_publishListener.transactionStart();
                }
                s_publishListener.doTask(qe);
                qe.delete();
            }
            catch (PublishToFileException e) {
                QueueManager.flagError(itemId, "PublishToFileException.", (Exception)((Object)e), qe, failedItems);
            }
            catch (Exception e) {
                QueueManager.flagError(itemId, "Task " + (Object)((Object)qe) + " failed:", e, qe, failedItems);
            }
            ++entryCount;
        }
        if (entryCount > 0) {
            s_publishListener.transactionEnd();
        }
        hasMore = !query.isAfterLast();
        return hasMore;
    }

    static DataQuery getBlockQuery() {
        DataQuery query = SessionManager.getSession().retrieveQuery("com.arsdigita.cms.publishToFile.getBlock");
        if ("GroupByParent".equals(s_blockSelectMethod)) {
            query.addOrder("queueEntry.parentId, queueEntry.sortOrder");
        } else {
            query.addOrder("queueEntry.sortOrder");
        }
        return query;
    }

    private static void flagError(BigDecimal itemId, String exName, Exception e, QueueEntry qe, HashSet failedItems) {
        failedItems.add(itemId);
        Long failCount = qe.getFailCount();
        s_log.error((Object)(exName + "  itemId=" + itemId + " task=" + (Object)((Object)qe) + " destination=" + qe.getDestination() + " failCount=" + failCount + " error=" + e.getMessage()), (Throwable)e);
        DataOperation operation = SessionManager.getSession().retrieveDataOperation("com.arsdigita.cms.publishToFile.flagPublishFailed");
        operation.setParameter("id", (Object)qe.getID());
        operation.execute();
    }
}

