/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.search;

import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.FileAsset;
import com.arsdigita.cms.TextAsset;
import com.arsdigita.cms.search.RawContentProvider;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectTraversal;
import com.arsdigita.domain.DomainServiceInterfaceExposer;
import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.persistence.metadata.Property;
import com.arsdigita.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class AssetExtractor
extends DomainObjectTraversal {
    private static final Logger s_log = Logger.getLogger(AssetExtractor.class);
    private List m_content = new ArrayList();
    public static final String TEXT_ASSET_DATA_OBJ = "com.arsdigita.cms.TextAsset";
    public static final String FILE_ASSET_DATA_OBJ = "com.arsdigita.cms.FileAsset";

    public List getContent() {
        return this.m_content;
    }

    protected void beginObject(DomainObject obj, String path) {
        if (!ContentSection.getConfig().getDisableFileAssetExtraction() && obj.getObjectType().isSubtypeOf(FILE_ASSET_DATA_OBJ)) {
            FileAsset fa = (FileAsset)obj;
            this.m_content.add(new RawContentProvider("file", fa.getContent()));
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Adding file provider for object " + fa.getOID()));
            }
        }
    }

    protected void endObject(DomainObject obj, String path) {
    }

    protected void revisitObject(DomainObject obj, String path) {
    }

    protected void handleAttribute(DomainObject obj, String path, Property property) {
        Object value = DomainServiceInterfaceExposer.get((DomainObject)obj, (String)property.getName());
        if (value != null && property.isRole() && value instanceof DataObject) {
            ObjectType assetType = ((DataObject)value).getOID().getObjectType();
            String assetTypeName = assetType.getQualifiedName();
            if (assetTypeName.equals(TEXT_ASSET_DATA_OBJ)) {
                TextAsset ta = new TextAsset((DataObject)value);
                String text = ta.getText();
                if (text != null) {
                    text = StringUtils.htmlToText((String)text);
                    this.m_content.add(new RawContentProvider("text", text.getBytes()));
                }
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)("Adding text provider for attribute " + ta.getOID()));
                }
            } else if (assetTypeName.equals(FILE_ASSET_DATA_OBJ)) {
                if (!ContentSection.getConfig().getDisableFileAssetExtraction()) {
                    FileAsset fa = new FileAsset((DataObject)value);
                    this.m_content.add(new RawContentProvider("file", fa.getContent()));
                    if (s_log.isDebugEnabled()) {
                        s_log.debug((Object)("Adding file provider for attribute " + fa.getOID()));
                    }
                }
            } else if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Don't know what to do with property " + property.getName() + " of type " + assetTypeName));
            }
        } else if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Ignoring property " + property.getName() + " of type " + value.getClass().getName()));
        }
    }

    protected void beginRole(DomainObject obj, String path, Property property) {
    }

    protected void endRole(DomainObject obj, String path, Property property) {
    }

    protected void beginAssociation(DomainObject obj, String path, Property property) {
        DataAssociation association;
        if (!ContentSection.getConfig().getDisableFileAssetExtraction() && (association = (DataAssociation)DomainServiceInterfaceExposer.get((DomainObject)obj, (String)property.getName())) != null && association.getObjectType().isSubtypeOf(FILE_ASSET_DATA_OBJ)) {
            while (association.next()) {
                FileAsset fa = new FileAsset(association.getDataObject());
                this.m_content.add(new RawContentProvider("file", fa.getContent()));
                if (!s_log.isDebugEnabled()) continue;
                s_log.debug((Object)("Adding file provider for association " + fa.getOID()));
            }
        }
    }

    protected void endAssociation(DomainObject obj, String path, Property property) {
    }
}

