/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.search;

import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentPage;
import com.arsdigita.cms.search.AssetExtractor;
import com.arsdigita.cms.search.TextContentProvider;
import com.arsdigita.cms.search.XMLContentProvider;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.kernel.Party;
import com.arsdigita.search.ContentProvider;
import com.arsdigita.search.ContentType;
import com.arsdigita.search.MetadataProvider;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Logger;

public abstract class ContentItemMetadataProvider
implements MetadataProvider {
    private static final Logger s_log = Logger.getLogger(ContentItemMetadataProvider.class);

    public String getTypeSpecificInfo(DomainObject dobj) {
        ContentItem item = (ContentItem)dobj;
        return "live".equals(item.getVersion()) ? "live" : "draft";
    }

    public Locale getLocale(DomainObject dobj) {
        ContentItem item = (ContentItem)dobj;
        String lang = item.getLanguage();
        return lang == null ? null : new Locale(lang, "");
    }

    public Date getCreationDate(DomainObject dobj) {
        ContentItem item = (ContentItem)dobj;
        return item.getCreationDate();
    }

    public Party getCreationParty(DomainObject dobj) {
        ContentItem item = (ContentItem)dobj;
        return item.getCreationUser();
    }

    public Date getLastModifiedDate(DomainObject dobj) {
        ContentItem item = (ContentItem)dobj;
        return item.getLastModifiedDate();
    }

    public Party getLastModifiedParty(DomainObject dobj) {
        ContentItem item = (ContentItem)dobj;
        return item.getLastModifiedUser();
    }

    public boolean isIndexable(DomainObject dobj) {
        return true;
    }

    public ContentProvider[] getContent(DomainObject dobj, ContentType type) {
        ArrayList<Object> content = new ArrayList<Object>();
        if (type == ContentType.XML) {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Adding XML Content for " + dobj.getOID()));
            }
            content.add(new XMLContentProvider("xml", dobj, this.getClass().getName()));
        } else if (type == ContentType.TEXT) {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Adding Text Content for " + dobj.getOID()));
            }
            content.add(new TextContentProvider("text", dobj, this.getClass().getName()));
            if (dobj instanceof ContentPage) {
                if (((ContentPage)dobj).indexAssetsWithPage()) {
                    content.add(new TextContentProvider("text", dobj, AssetExtractor.class.getName()));
                }
            } else {
                content.add(new TextContentProvider("text", dobj, AssetExtractor.class.getName()));
            }
        } else if (type == ContentType.RAW) {
            if (dobj instanceof ContentPage) {
                if (((ContentPage)dobj).indexAssetsWithPage()) {
                    AssetExtractor ex = new AssetExtractor();
                    ex.walk(dobj, AssetExtractor.class.getName());
                    content.addAll(ex.getContent());
                }
            } else {
                AssetExtractor ex = new AssetExtractor();
                ex.walk(dobj, AssetExtractor.class.getName());
                content.addAll(ex.getContent());
            }
        }
        return content.toArray(new ContentProvider[content.size()]);
    }
}

