/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.search;

import com.arsdigita.cms.ContentPage;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.search.ContentItemMetadataProvider;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.util.StringUtils;
import org.apache.log4j.Logger;

public class ContentPageMetadataProvider
extends ContentItemMetadataProvider {
    public static final String ADAPTER_CONTEXT = ContentPageMetadataProvider.class.getName();
    private static final Logger s_log = Logger.getLogger(ContentPageMetadataProvider.class);

    public String getTitle(DomainObject dobj) {
        if (dobj instanceof ContentPage) {
            ContentPage item = (ContentPage)dobj;
            s_log.debug((Object)String.format("getting title of item with oid '%s'", item.getOID().toString()));
            s_log.debug((Object)String.format("and name '%s'", item.getName()));
            s_log.debug((Object)String.format("and title '%s'", item.getTitle()));
            String title = item.getTitle();
            if (StringUtils.emptyString((String)title)) {
                throw new IllegalArgumentException("ContentPage must have non-blank title!");
            }
            return title;
        }
        s_log.warn((Object)"Item is not a ContentPage.");
        return "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx";
    }

    public String getSummary(DomainObject dobj) {
        if (dobj instanceof ContentPage) {
            ContentPage item = (ContentPage)dobj;
            return item.getSearchSummary();
        }
        return "";
    }

    public String getContentSection(DomainObject dobj) {
        ContentPage item;
        ContentSection section;
        String sectionName = "";
        if (dobj instanceof ContentPage && (section = (item = (ContentPage)dobj).getContentSection()) != null) {
            sectionName = section.getName();
        }
        return sectionName;
    }
}

