/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.search;

import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.search.ContentTypeFilterType;
import com.arsdigita.search.FilterSpecification;
import com.arsdigita.search.FilterType;
import com.arsdigita.util.Assert;

public class ContentTypeFilterSpecification
extends FilterSpecification {
    public static final String TYPES = "types";

    public ContentTypeFilterSpecification(String typeName) {
        this(ContentTypeFilterSpecification.lookupTypes(new String[]{typeName}));
    }

    public ContentTypeFilterSpecification(String[] typeNames) {
        this(ContentTypeFilterSpecification.lookupTypes(typeNames));
    }

    public ContentTypeFilterSpecification(ContentType type) {
        super(new Object[]{TYPES, new ContentType[]{type}}, (FilterType)new ContentTypeFilterType());
    }

    public ContentTypeFilterSpecification(ContentType[] types) {
        super(new Object[]{TYPES, types}, (FilterType)new ContentTypeFilterType());
    }

    public ContentType[] getTypes() {
        return (ContentType[])this.get(TYPES);
    }

    private static ContentType[] lookupTypes(String[] typeNames) {
        Assert.exists((Object)typeNames, String[].class);
        ContentType[] types = new ContentType[typeNames.length];
        for (int i = 0; i < typeNames.length; ++i) {
            types[i] = ContentType.findByAssociatedObjectType(typeNames[i]);
        }
        return types;
    }
}

