/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.search;

import com.arsdigita.categorization.Category;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.search.CMSContentSectionFilterSpecification;
import com.arsdigita.cms.search.ContentTypeFilterSpecification;
import com.arsdigita.cms.search.PathSearchSpecification;
import com.arsdigita.cms.search.VersionFilterSpecification;
import com.arsdigita.kernel.PartyCollection;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.Filter;
import com.arsdigita.search.FilterSpecification;
import com.arsdigita.search.FilterType;
import com.arsdigita.search.Search;
import com.arsdigita.search.filters.CategoryFilterSpecification;
import com.arsdigita.search.filters.DateRangeFilterSpecification;
import com.arsdigita.search.filters.PartyFilterSpecification;
import com.arsdigita.search.intermedia.BaseQueryEngine;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class IntermediaQueryEngine
extends BaseQueryEngine {
    public IntermediaQueryEngine() {
        this.addColumn("version", "i.version");
        this.addColumn("launch_date", "p.launch_date");
        this.addColumn("last_modified", "audited.last_modified");
        this.addColumn("modifying_user", "audited.modifying_user");
        this.addColumn("creation_date", "audited.creation_date");
        this.addColumn("creation_user", "audited.creation_user");
        if (ContentSection.getConfig().scoreKeywordsAndTitle()) {
            this.addColumn("score", "((score(1) * " + Search.getConfig().getXMLContentWeight() + ") +" + " (score(2) * " + Search.getConfig().getRawContentWeight() + ") +" + " (score(3) * " + ContentSection.getConfig().getKeywordSearchWeight() + ") +" + " (score(4) * " + ContentSection.getConfig().getTitleSearchWeight() + "))");
        }
        this.addTable("search_content", "c left outer join cms_pages p on ( p.item_id = c.object_id ) left outer join cms_items i on (c.object_id = i.item_id ) left outer join acs_auditing audited on (c.object_id = audited.object_id)");
    }

    protected String cleanSearchString(String terms) {
        if (ContentSection.getConfig().scoreKeywordsAndTitle()) {
            return PathSearchSpecification.cleanSearchString((String)terms, (String)" AND ");
        }
        return super.cleanSearchString(terms);
    }

    protected String getContainsClause(String terms) {
        if (ContentSection.getConfig().scoreKeywordsAndTitle()) {
            return PathSearchSpecification.containsClause("c", terms, "1", "2", "3", "4") + "\n";
        }
        return super.getContainsClause(terms);
    }

    protected void addFilter(DataQuery query, FilterSpecification filter) {
        super.addFilter(query, filter);
        FilterType type = filter.getType();
        if ("contentType".equals(type.getKey())) {
            this.addContentTypeFilter(query, (ContentTypeFilterSpecification)filter);
        } else if ("version".equals(type.getKey())) {
            this.addVersionFilter(query, (VersionFilterSpecification)filter);
        } else if ("launchDate".equals(type.getKey())) {
            this.addLaunchDateFilter(query, (DateRangeFilterSpecification)filter);
        } else if ("lastModifiedDate".equals(type.getKey())) {
            this.addLastModifiedDateFilter(query, (DateRangeFilterSpecification)filter);
        } else if ("creationDate".equals(type.getKey())) {
            this.addCreationDateFilter(query, (DateRangeFilterSpecification)filter);
        } else if ("lastModifiedUser".equals(type.getKey())) {
            this.addPartyFilter(query, (PartyFilterSpecification)filter, "modifying_user");
        } else if ("creationUser".equals(type.getKey())) {
            this.addPartyFilter(query, (PartyFilterSpecification)filter, "creation_user");
        } else if ("cmsContentSection".equals(type.getKey())) {
            this.addCMSContentSectionFilter(query, (CMSContentSectionFilterSpecification)filter);
        }
    }

    protected void addCMSContentSectionFilter(DataQuery query, CMSContentSectionFilterSpecification filter) {
        if (filter.getSections() == null) {
            return;
        }
        Filter f = null;
        f = filter.isExclusion() ? query.addNotInSubqueryFilter("object_id", "com.arsdigita.cms.getContentSectionItems") : query.addInSubqueryFilter("object_id", "com.arsdigita.cms.getContentSectionItems");
        f.set("sectionName", Arrays.asList(filter.getSections()));
    }

    protected void addVersionFilter(DataQuery query, VersionFilterSpecification filter) {
        Filter f = query.addFilter("nvl(version,'" + filter.getVersion() + "') = :version");
        f.set("version", (Object)filter.getVersion());
    }

    protected void addLaunchDateFilter(DataQuery query, DateRangeFilterSpecification filter) {
        this.addDateRangeFilter(query, filter, "launch_date");
    }

    protected void addLastModifiedDateFilter(DataQuery query, DateRangeFilterSpecification filter) {
        this.addDateRangeFilter(query, filter, "last_modified");
    }

    protected void addCreationDateFilter(DataQuery query, DateRangeFilterSpecification filter) {
        this.addDateRangeFilter(query, filter, "creation_date");
    }

    private void addDateRangeFilter(DataQuery query, DateRangeFilterSpecification filter, String columnName) {
        Filter f;
        Date start = filter.getStartDate();
        Date end = filter.getEndDate();
        SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy");
        if (start != null) {
            f = query.addFilter(columnName + " >= :" + columnName + "StartDate");
            Calendar startCal = GregorianCalendar.getInstance();
            startCal.setTime(start);
            startCal.set(12, 0);
            startCal.set(11, 0);
            startCal.set(13, 0);
            f.set(columnName + "StartDate", (Object)startCal.getTime());
        }
        if (end != null) {
            f = query.addFilter(columnName + " < :" + columnName + "EndDate");
            Calendar endCal = GregorianCalendar.getInstance();
            endCal.setTime(end);
            endCal.set(12, 0);
            endCal.set(11, 0);
            endCal.set(13, 0);
            f.set(columnName + "EndDate", (Object)endCal.getTime());
        }
    }

    protected void addPartyFilter(DataQuery query, PartyFilterSpecification filter, String columnName) {
        PartyCollection parties = filter.getParties();
        if (parties == null) {
            return;
        }
        ArrayList<BigDecimal> partyIDs = new ArrayList<BigDecimal>();
        while (parties.next()) {
            partyIDs.add(parties.getID());
        }
        if (partyIDs.size() == 0) {
            query.addFilter("1=2");
        } else {
            Filter f = query.addFilter(columnName + " in :" + columnName + "parties");
            f.set(columnName + "parties", partyIDs);
        }
    }

    protected void addContentTypeFilter(DataQuery query, ContentTypeFilterSpecification filter) {
        ArrayList<String> l = new ArrayList<String>();
        ContentType[] types = filter.getTypes();
        if (types == null || types.length == 0) {
            return;
        }
        for (int i = 0; i < types.length; ++i) {
            ContentType type = types[i];
            l.add(type.getAssociatedObjectType());
        }
        Filter f = query.addFilter("object_type in :types");
        f.set("types", l);
    }

    protected void addCategoryFilter(DataQuery query, CategoryFilterSpecification filter) {
        Category[] categories = filter.getCategories();
        if (categories != null && categories.length > 0) {
            ArrayList<BigDecimal> ids = new ArrayList<BigDecimal>();
            for (int i = 0; i < categories.length; ++i) {
                ids.add(categories[i].getID());
            }
            Filter f = query.addInSubqueryFilter("object_id", "id", "com.arsdigita.cms.searchCategoryObjects");
            f.set("ids", ids);
            f.set("pathLimit", (Object)new Integer(filter.isDescending() ? 999999 : 0));
        }
    }
}

