/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.search;

import com.arsdigita.cms.ContentSection;
import com.arsdigita.search.intermedia.SimpleSearchSpecification;
import org.apache.log4j.Logger;

public class PathSearchSpecification
extends SimpleSearchSpecification {
    private static Logger s_log = Logger.getLogger(PathSearchSpecification.class);

    public PathSearchSpecification(String object_type, String searchString) {
        super(object_type, searchString);
    }

    public PathSearchSpecification(String searchString) {
        this(null, searchString);
    }

    public static String containsClause(String sc, String searchString, String xml_label, String raw_label, String keyword_label, String title_label) {
        StringBuffer clause = new StringBuffer();
        String quotedSS = PathSearchSpecification.quote((String)searchString);
        if (xml_label != null) {
            clause.append("contains(" + sc + ".xml_content, " + quotedSS + ", " + xml_label + ") > 0");
        }
        if (raw_label != null) {
            if (!clause.toString().equals("")) {
                clause.append(" or ");
            }
            clause.append("contains(" + sc + ".raw_content, " + quotedSS + ", " + raw_label + ") > 0");
        }
        if (ContentSection.getConfig().scoreKeywordsAndTitle()) {
            if (!clause.toString().equals("")) {
                clause.append(" or ");
            }
            clause.append("contains(" + sc + ".xml_content, ");
            clause.append(PathSearchSpecification.quote((String)("(" + searchString + ") INPATH (cms:item/dublinCore/dcKeywords)")));
            clause.append(", " + keyword_label + ") > 0");
            clause.append(" or contains(" + sc + ".xml_content, ");
            clause.append(PathSearchSpecification.quote((String)("(" + searchString + ") INPATH (cms:item/title)")));
            clause.append(", " + title_label + ") > 0");
        }
        String clauseString = clause.toString().equals("") ? "" : "(" + clause.toString() + ")";
        s_log.debug((Object)clauseString);
        return clauseString;
    }
}

