/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.search;

import com.arsdigita.cms.ContentPage;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.FileAsset;
import com.arsdigita.cms.TextAsset;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectTraversal;
import com.arsdigita.domain.DomainServiceInterfaceExposer;
import com.arsdigita.mimetypes.MimeType;
import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.persistence.metadata.Property;
import com.arsdigita.search.ContentProvider;
import com.arsdigita.search.ContentType;
import com.arsdigita.search.converter.ConversionException;
import com.arsdigita.search.converter.Converter;
import com.arsdigita.search.converter.ConverterRegistry;
import com.arsdigita.util.StringUtils;
import org.apache.log4j.Logger;

public class TextContentProvider
implements ContentProvider {
    private DomainObject m_obj;
    private String m_context;
    private String m_adapterContext;

    public TextContentProvider(String context, DomainObject obj, String adapterContext) {
        this.m_context = context;
        this.m_obj = obj;
        this.m_adapterContext = adapterContext;
    }

    public String getContext() {
        return this.m_context;
    }

    public ContentType getType() {
        return ContentType.TEXT;
    }

    public byte[] getBytes() {
        TextRenderer renderer = new TextRenderer();
        renderer.walk(this.m_obj, this.m_adapterContext);
        String text = renderer.getText();
        return text.getBytes();
    }

    public class TextRenderer
    extends DomainObjectTraversal {
        private Logger s_log = Logger.getLogger(TextRenderer.class);
        private StringBuffer m_text = new StringBuffer("");

        public String getText() {
            return this.m_text.toString();
        }

        protected void beginObject(DomainObject obj, String path) {
            if (!ContentSection.getConfig().getDisableFileAssetExtraction() && obj.getObjectType().isSubtypeOf("com.arsdigita.cms.FileAsset")) {
                FileAsset fa = (FileAsset)obj;
                this.appendFileAsset(fa);
                if (this.s_log.isDebugEnabled()) {
                    this.s_log.debug((Object)("Adding file asset object " + fa.getOID()));
                }
            }
        }

        protected void endObject(DomainObject obj, String path) {
        }

        protected void revisitObject(DomainObject obj, String path) {
        }

        protected void handleAttribute(DomainObject obj, String path, Property property) {
            Object value = DomainServiceInterfaceExposer.get((DomainObject)obj, (String)property.getName());
            if (value != null && property.isRole() && value instanceof DataObject) {
                ObjectType assetType = ((DataObject)value).getOID().getObjectType();
                String assetTypeName = assetType.getQualifiedName();
                if (assetTypeName.equals("com.arsdigita.cms.TextAsset")) {
                    if (this.s_log.isDebugEnabled()) {
                        this.s_log.debug((Object)("Adding text asset attribute " + property.getName() + " for " + obj.getOID()));
                    }
                    this.appendTextAsset(new TextAsset((DataObject)value));
                } else if (assetTypeName.equals("com.arsdigita.cms.FileAsset") && !ContentSection.getConfig().getDisableFileAssetExtraction()) {
                    if (this.s_log.isDebugEnabled()) {
                        this.s_log.debug((Object)("Adding file asset attribute " + property.getName() + " for " + obj.getOID()));
                    }
                    FileAsset fa = new FileAsset((DataObject)value);
                    this.appendFileAsset(fa);
                }
            } else if (value != null && !property.isRole()) {
                this.m_text.append(" " + value);
            }
        }

        protected void beginRole(DomainObject obj, String path, Property property) {
        }

        protected void endRole(DomainObject obj, String path, Property property) {
        }

        protected void beginAssociation(DomainObject obj, String path, Property property) {
            block6: {
                DataAssociation association;
                block5: {
                    association = (DataAssociation)DomainServiceInterfaceExposer.get((DomainObject)obj, (String)property.getName());
                    if (association == null || !association.getObjectType().isSubtypeOf("com.arsdigita.cms.FileAsset")) break block5;
                    if (ContentSection.getConfig().getDisableFileAssetExtraction()) break block6;
                    while (association.next()) {
                        ContentPage cp;
                        if (this.s_log.isDebugEnabled()) {
                            this.s_log.debug((Object)("Adding file asset association " + property.getName() + " for " + obj.getOID()));
                        }
                        if (!obj.getObjectType().isSubtypeOf("com.arsdigita.cms.ContentPage") || !(cp = (ContentPage)obj).indexAssetsWithPage()) continue;
                        this.appendFileAsset(new FileAsset(association.getDataObject()));
                    }
                    break block6;
                }
                if (association != null && association.getObjectType().isSubtypeOf("com.arsdigita.cms.TextAsset")) {
                    while (association.next()) {
                        if (this.s_log.isDebugEnabled()) {
                            this.s_log.debug((Object)("Adding text asset association " + property.getName() + " for " + obj.getOID()));
                        }
                        this.appendTextAsset(new TextAsset(association.getDataObject()));
                    }
                }
            }
        }

        protected void endAssociation(DomainObject obj, String path, Property property) {
        }

        private void appendTextAsset(TextAsset asset) {
            String content = asset.getText();
            if (content != null) {
                this.m_text.append(" " + StringUtils.htmlToText((String)content));
            }
        }

        private void appendFileAsset(FileAsset asset) {
            Converter converter = ConverterRegistry.getConverter((MimeType)asset.getMimeType());
            if (converter != null) {
                if (this.s_log.isDebugEnabled()) {
                    this.s_log.debug((Object)("Converting " + asset.getOID() + " using " + converter.getClass().getName()));
                }
                try {
                    String converted = converter.convertDocument(asset.getContent());
                    if (this.s_log.isDebugEnabled()) {
                        this.s_log.debug((Object)("Converted file is: " + converted));
                    }
                    this.m_text.append(" ").append(converted);
                }
                catch (ConversionException e) {
                    this.s_log.error((Object)("Error converting FileAsset " + asset.getOID() + " with MimeType " + asset.getMimeType()), (Throwable)e);
                }
            } else {
                this.s_log.debug((Object)("Skipping FileAsset " + asset.getOID() + " with MimeType " + asset.getMimeType()));
            }
        }
    }
}

