/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.search;

import com.arsdigita.cms.ContentItemXMLRenderer;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.search.ContentProvider;
import com.arsdigita.search.ContentType;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.xml.Document;
import com.arsdigita.xml.Element;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;

public class XMLContentProvider
implements ContentProvider {
    private static final Logger s_log = Logger.getLogger(XMLContentProvider.class);
    private DomainObject m_obj;
    private String m_context;
    private String m_adapterContext;

    public XMLContentProvider(String context, DomainObject obj, String adapterContext) {
        this.m_context = context;
        this.m_obj = obj;
        this.m_adapterContext = adapterContext;
    }

    public String getContext() {
        return this.m_context;
    }

    public ContentType getType() {
        return ContentType.XML;
    }

    public byte[] getBytes() {
        Element root = new Element("cms:item", "http://www.arsdigita.com/cms/1.0");
        ContentItemXMLRenderer renderer = new ContentItemXMLRenderer(root);
        renderer.setWrapAttributes(true);
        renderer.walk(this.m_obj, this.m_adapterContext);
        Document doc = null;
        try {
            doc = new Document(root);
        }
        catch (ParserConfigurationException ex) {
            String message = (String)GlobalizationUtil.globalize("cms.cannot_create_xml_document").localize();
            throw new UncheckedWrapperException(message, (Throwable)ex);
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("XML is " + doc.toString(true)));
        }
        String xml = doc.toString(true);
        return xml.getBytes();
    }
}

