/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Resettable;
import com.arsdigita.bebop.SegmentedPanel;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.Folder;
import com.arsdigita.cms.ui.BaseTree;
import com.arsdigita.cms.ui.FlatItemList;
import com.arsdigita.cms.ui.folder.FolderRequestLocal;
import com.arsdigita.cms.ui.folder.FolderSelectionModel;
import com.arsdigita.cms.ui.folder.FolderTreeModelBuilder;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.User;
import com.arsdigita.toolbox.ui.LayoutPanel;
import com.arsdigita.util.Assert;
import com.arsdigita.web.Web;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class BrowsePane
extends LayoutPanel
implements Resettable {
    private static final Logger s_log = Logger.getLogger(BrowsePane.class);
    private final BaseTree m_tree = new BaseTree(new FolderTreeModelBuilder());
    private final SingleSelectionModel m_model = this.m_tree.getSelectionModel();
    private final FolderSelectionModel m_folderModel = new FolderSelectionModel(this.m_model);
    private final FolderRequestLocal m_folder = new FolderRequestLocal((SingleSelectionModel)this.m_folderModel);
    private final FlatItemList m_fil;

    public BrowsePane() {
        SegmentedPanel left = new SegmentedPanel();
        this.setLeft((Component)left);
        Label heading = new Label(GlobalizationUtil.globalize("cms.ui.folder_browser"));
        left.addSegment((Component)heading, (Component)this.m_tree);
        this.m_fil = new FlatItemList(this.m_folder, this.m_folderModel);
        this.setBody((Component)this.m_fil);
        this.m_fil.getManipulator().getItemView().addProcessListener((FormProcessListener)new ProcessListener());
        this.m_fil.getManipulator().getTargetSelector().addProcessListener((FormProcessListener)new ProcessListener());
        this.m_fil.getManipulator().getTargetSelector().addSubmissionListener((FormSubmissionListener)new SubmissionListener());
    }

    public final void register(Page page) {
        super.register(page);
        page.addActionListener((ActionListener)new FolderListener());
        page.addActionListener((ActionListener)new TreeListener());
    }

    public final void reset(PageState state) {
        super.reset(state);
        this.m_fil.reset(state);
    }

    private final class TreeListener
    implements ActionListener {
        private TreeListener() {
        }

        public final void actionPerformed(ActionEvent e) {
            Folder root;
            PageState state = e.getPageState();
            if (Assert.isEnabled()) {
                Assert.isTrue((boolean)BrowsePane.this.m_model.isSelected(state));
            }
            if (!(root = CMS.getContext().getContentSection().getRootFolder()).equals(BrowsePane.this.m_folder.getFolder(state))) {
                Folder object = BrowsePane.this.m_folder.getFolder(state);
                while (object != null) {
                    if (object instanceof Folder) {
                        ACSObject result = object.getParent();
                        if (result instanceof Folder) {
                            object = result;
                            BrowsePane.this.m_tree.expand(object.getID().toString(), state);
                            continue;
                        }
                        object = null;
                        continue;
                    }
                    object = null;
                }
            }
        }
    }

    private final class FolderListener
    implements ActionListener {
        private FolderListener() {
        }

        public final void actionPerformed(ActionEvent e) {
            PageState state = e.getPageState();
            if (!BrowsePane.this.m_model.isSelected(state)) {
                String folder = state.getRequest().getParameter("set_folder");
                if (folder == null) {
                    Folder homeFolder;
                    Folder root = CMS.getContext().getContentSection().getRootFolder();
                    BigDecimal folderID = root.getID();
                    User user = Web.getContext().getUser();
                    if (user != null && (homeFolder = Folder.getUserHomeFolder(user, CMS.getContext().getContentSection())) != null) {
                        folderID = homeFolder.getID();
                    }
                    BrowsePane.this.m_model.setSelectedKey(state, (Object)folderID);
                } else {
                    BrowsePane.this.m_model.setSelectedKey(state, (Object)folder);
                }
            }
        }
    }

    private final class SubmissionListener
    implements FormSubmissionListener {
        private SubmissionListener() {
        }

        public final void submitted(FormSectionEvent e) {
            PageState s = e.getPageState();
            if (e.getSource() == BrowsePane.this.m_fil.getManipulator().getTargetSelector() && !BrowsePane.this.m_fil.getManipulator().getTargetSelector().isVisible(s)) {
                BrowsePane.this.m_tree.setVisible(s, true);
            }
        }
    }

    private final class ProcessListener
    implements FormProcessListener {
        private ProcessListener() {
        }

        public final void process(FormSectionEvent e) {
            PageState state = e.getPageState();
            if (e.getSource() == BrowsePane.this.m_fil.getManipulator().getItemView()) {
                BrowsePane.this.m_tree.setVisible(state, false);
            } else if (e.getSource() == BrowsePane.this.m_fil.getManipulator().getTargetSelector()) {
                BrowsePane.this.m_tree.setVisible(state, true);
            }
        }
    }
}

