/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.Bebop;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.page.PageTransformer;
import com.arsdigita.cms.CMSExcursion;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ContentSectionServlet;
import com.arsdigita.cms.SecurityManager;
import com.arsdigita.cms.dispatcher.AccessDeniedException;
import com.arsdigita.cms.dispatcher.ContentSectionDispatcher;
import com.arsdigita.cms.dispatcher.Utilities;
import com.arsdigita.developersupport.DeveloperSupport;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelHelper;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.persistence.OID;
import com.arsdigita.templating.PresentationManager;
import com.arsdigita.util.Assert;
import com.arsdigita.web.Application;
import com.arsdigita.xml.Document;
import com.arsdigita.xml.Element;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class CMSApplicationPage
extends Page {
    private static final Logger s_log = Logger.getLogger(CMSApplicationPage.class);
    public static final String ASSETS = "ASSETS";
    public static final String PAGE_CLASS = "CMS";
    private HashMap m_params;
    private PageTransformer m_transformer;

    public CMSApplicationPage() {
        this.buildPage();
    }

    public CMSApplicationPage(String title) {
        super(title);
        this.buildPage();
    }

    public CMSApplicationPage(String title, Container panel) {
        super(title, panel);
        this.buildPage();
    }

    public CMSApplicationPage(Label title) {
        super(title);
        this.buildPage();
    }

    public CMSApplicationPage(Label title, Container panel) {
        super(title, panel);
        this.buildPage();
    }

    protected void buildPage() {
        this.setClassAttr(PAGE_CLASS);
        this.m_params = new HashMap();
        this.setXMLParameter(ASSETS, Utilities.getGlobalAssetsURL());
        this.setAttribute(ASSETS, Utilities.getGlobalAssetsURL());
        this.getErrorDisplay().setIdAttr("page-body");
        PresentationManager pm = Bebop.getConfig().getPresentationManager();
        this.m_transformer = pm instanceof PageTransformer ? (PageTransformer)pm : new PageTransformer();
    }

    public synchronized void init() {
        s_log.debug((Object)"Initializing the page");
        if (!this.isLocked()) {
            s_log.debug((Object)"The page hasn't been locked; locking it now");
            this.lock();
        }
    }

    public String getXMLParameter(String name) {
        return (String)this.m_params.get(name);
    }

    public void setXMLParameter(String name, String value) {
        this.m_params.put(name, value);
    }

    public ContentSection getContentSection(HttpServletRequest request) {
        return ContentSectionServlet.getContentSection(request);
    }

    public ContentSection getContentSection(PageState state) {
        return this.getContentSection(state.getRequest());
    }

    public ContentItem getContentItem(HttpServletRequest request) {
        return ContentSectionDispatcher.getContentItem(request);
    }

    public ContentItem getContentItem(PageState state) {
        return this.getContentItem(state.getRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch(final HttpServletRequest request, final HttpServletResponse response) throws IOException, ServletException {
        DeveloperSupport.startStage((String)"CMSPage.dispatch: serve page");
        CMSExcursion excursion = new CMSExcursion(){

            @Override
            public void excurse() throws IOException, ServletException {
                String itemID;
                Application app = Application.getCurrentApplication((HttpServletRequest)request);
                ContentSection section = null;
                if (app != null) {
                    if (app instanceof ContentSection) {
                        section = (ContentSection)app;
                    } else if ((app = app.getParentApplication()) instanceof ContentSection) {
                        section = (ContentSection)app;
                    }
                }
                if (section != null) {
                    this.setContentSection(section);
                    this.setSecurityManager(new SecurityManager(section));
                }
                if ((itemID = request.getParameter("item_id")) != null) {
                    try {
                        ContentItem item = (ContentItem)DomainObjectFactory.newInstance((OID)new OID("com.arsdigita.cms.ContentItem", (Object)new BigDecimal(itemID)));
                        this.setContentItem(item);
                        PermissionDescriptor perm = new PermissionDescriptor(SecurityManager.CMS_PREVIEW_ITEM_DESCRIPTOR, (ACSObject)item, Kernel.getContext().getParty());
                        if (!PermissionService.checkPermission((PermissionDescriptor)perm)) {
                            s_log.warn((Object)("No perm to CMS_PREVIEW_ITEM " + itemID));
                            throw new AccessDeniedException("You do not have privileges to administer item " + itemID);
                        }
                    }
                    catch (DataObjectNotFoundException donfe) {
                        s_log.warn((Object)("Failed to load content item " + itemID));
                    }
                }
                Document doc = CMSApplicationPage.this.buildDocument(request, response);
                Assert.exists((Object)CMSApplicationPage.this.m_transformer, (String)"Implementation of PresentationManager");
                CMSApplicationPage.this.m_transformer.servePage(doc, request, response, (Map)CMSApplicationPage.this.m_params);
            }
        };
        try {
            excursion.run();
        }
        finally {
            DeveloperSupport.endStage((String)"CMSPage.dispatch: serve page");
        }
    }

    protected Element generateXMLHelper(PageState ps, Document parent) {
        Element page = super.generateXMLHelper(ps, parent);
        User user = CMSApplicationPage.getCurrentUser(ps);
        if (user != null) {
            page.addAttribute("name", user.getDisplayName());
        }
        return page;
    }

    public static User getCurrentUser(PageState state) {
        return KernelHelper.getCurrentUser((HttpServletRequest)state.getRequest());
    }
}

