/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormValidationListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.OptionGroup;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.util.SequentialMap;
import com.arsdigita.categorization.Category;
import com.arsdigita.categorization.CategoryCollection;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ui.authoring.BasicItemForm;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.StringUtils;
import com.arsdigita.util.UncheckedWrapperException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Map;
import java.util.TooManyListenersException;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public abstract class CategoryForm
extends Form
implements FormProcessListener,
FormValidationListener {
    private RequestLocal m_assigned;
    private Submit m_assign;
    private Submit m_remove;
    Label m_freeLabel;
    Label m_assignedLabel;
    private static final String SEPARATOR = ">";
    public static final String FREE = "free";
    public static final String ASSIGNED = "assigned";
    public static final String ASSIGN = "assign";
    public static final String REMOVE = "remove";
    public static final int SELECT_WIDTH = 30;
    public static final int SELECT_HEIGHT = 10;
    public static final String FILLER_OPTION = StringUtils.repeat((String)"_", (int)30);
    private static final Logger s_log = Logger.getLogger(CategoryForm.class);

    public CategoryForm(String name) {
        super(name, (Container)new ColumnPanel(3));
        ColumnPanel panel = (ColumnPanel)this.getPanel();
        panel.setBorder(false);
        panel.setPadColor("#FFFFFF");
        panel.setColumnWidth(1, "0%");
        panel.setColumnWidth(2, "0%");
        panel.setColumnWidth(3, "0");
        panel.setWidth("0%");
        panel.setClassAttr("CMS Admin");
        this.m_assigned = new RequestLocal(){

            public Object initialValue(PageState state) {
                CategoryMap m = new CategoryMap();
                CategoryForm.this.initAssignedCategories(state, m);
                return m;
            }
        };
        this.m_freeLabel = new Label(GlobalizationUtil.globalize("cms.ui.item.categories.available"), false);
        this.m_freeLabel.setFontWeight("b");
        this.add((Component)this.m_freeLabel, 1);
        this.add((Component)new Label("&nbsp;", false));
        this.m_assignedLabel = new Label(GlobalizationUtil.globalize("cms.ui.item.categories.assigned"), false);
        this.m_assignedLabel.setFontWeight("b");
        this.add((Component)this.m_assignedLabel, 1);
        SingleSelect freeWidget = new SingleSelect((ParameterModel)new BigDecimalParameter(FREE));
        try {
            freeWidget.addPrintListener((PrintListener)new FreePrintListener());
        }
        catch (TooManyListenersException e) {
            UncheckedWrapperException.throwLoggedException(((Object)((Object)this)).getClass(), (String)"Too many listeners", (Throwable)e);
        }
        freeWidget.setSize(10);
        this.add((Component)freeWidget);
        BoxPanel box = new BoxPanel(2, true);
        box.setWidth("2%");
        this.addSubmitButtons((Container)box);
        this.add((Component)box, 18);
        SingleSelect assignedWidget = new SingleSelect((ParameterModel)new BigDecimalParameter(ASSIGNED));
        try {
            assignedWidget.addPrintListener((PrintListener)new AssignedPrintListener());
        }
        catch (TooManyListenersException e) {
            UncheckedWrapperException.throwLoggedException(((Object)((Object)this)).getClass(), (String)"Too many listeners", (Throwable)e);
        }
        assignedWidget.setSize(10);
        this.add((Component)assignedWidget);
        this.addProcessListener(this);
        this.addValidationListener(this);
        this.setClassAttr("CategoryForm");
    }

    protected void addSubmitButtons(Container c) {
        this.addAssignButton(c);
        this.addRemoveButton(c);
    }

    protected void addAssignButton(Container c) {
        this.m_assign = new Submit(ASSIGN, ">>");
        this.m_assign.setSize(10);
        c.add((Component)this.m_assign);
    }

    protected void addRemoveButton(Container c) {
        this.m_remove = new Submit(REMOVE, "<<");
        this.m_remove.setSize(10);
        c.add((Component)this.m_remove);
    }

    public void setUnassignedCaption(String caption) {
        this.m_freeLabel.setLabel(caption);
    }

    public void setAssignedCaption(String caption) {
        this.m_assignedLabel.setLabel(caption);
    }

    public CategoryMap getAssignedCategories(PageState s) {
        return (CategoryMap)((Object)this.m_assigned.get(s));
    }

    protected abstract void initAssignedCategories(PageState var1, CategoryMap var2);

    protected abstract void assignCategory(PageState var1, Category var2);

    protected abstract void unassignCategory(PageState var1, Category var2);

    protected abstract String getItemURL(PageState var1);

    protected abstract ACSObject getObject(PageState var1);

    public Category getRootCategory(PageState state) {
        return CMS.getContext().getContentSection().getRootCategory();
    }

    protected Category getExcludedCategory(PageState s) {
        return null;
    }

    public void process(FormSectionEvent e) throws FormProcessException {
        PageState state = e.getPageState();
        FormData data = e.getFormData();
        if (this.m_assign.isSelected(state)) {
            BigDecimal id = (BigDecimal)data.get((Object)FREE);
            try {
                Category cat = new Category(new OID("com.arsdigita.categorization.Category", (Object)id));
                if (!cat.canMap()) {
                    data.addError((String)GlobalizationUtil.globalize("cms.ui.need_category_map_privilege").localize());
                    return;
                }
                this.assignCategory(state, cat);
                data.put((Object)ASSIGNED, (Object)id);
            }
            catch (DataObjectNotFoundException ex) {
                s_log.error((Object)"Couldn't find Category", (Throwable)ex);
                throw new FormProcessException((Throwable)ex);
            }
        }
        if (this.m_remove.isSelected(state)) {
            BigDecimal id = (BigDecimal)data.get((Object)ASSIGNED);
            try {
                Category cat = new Category(new OID("com.arsdigita.categorization.Category", (Object)id));
                if (!cat.canMap()) {
                    data.addError((String)GlobalizationUtil.globalize("cms.ui.need_category_map_privilege").localize());
                    return;
                }
                this.unassignCategory(state, cat);
                data.put((Object)FREE, (Object)id);
            }
            catch (DataObjectNotFoundException ex) {
                s_log.error((Object)"Couldn't find category");
                throw new FormProcessException((Throwable)ex);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void validate(FormSectionEvent e) throws FormProcessException {
        PageState state = e.getPageState();
        FormData data = e.getFormData();
        if (this.m_assign.isSelected(state)) {
            if (data.get((Object)FREE) == null) {
                data.addError("Please select a category to assign");
                return;
            } else {
                BigDecimal id = (BigDecimal)data.get((Object)FREE);
                try {
                    Category cat = new Category(new OID("com.arsdigita.categorization.Category", (Object)id));
                    String url = this.getItemURL(state);
                    if (url == null) return;
                    DataQuery query = SessionManager.getSession().retrieveQuery("com.arsdigita.categorization.getAllItemURLsForCategory");
                    query.setParameter("categoryID", (Object)id);
                    query.addEqualsFilter("lower(url)", (Object)url.toLowerCase());
                    if (query.size() <= 0L) return;
                    ACSObject item = this.getObject(state);
                    ArrayList<BigDecimal> list = null;
                    if (item instanceof ContentItem) {
                        list = BasicItemForm.getAllVersionIDs((ContentItem)item);
                    } else {
                        list = new ArrayList<BigDecimal>();
                        list.add(item.getID());
                    }
                    BigDecimal itemID = null;
                    while (query.next()) {
                        itemID = (BigDecimal)query.get("itemID");
                        if (list.contains(itemID)) continue;
                        data.addError("There is already an item with the url " + url + " in the category " + cat.getName());
                        return;
                    }
                    return;
                }
                catch (DataObjectNotFoundException ex) {
                    s_log.error((Object)("Error processing category.  Unable to find category with id " + id));
                    throw new FormProcessException((Throwable)ex);
                }
            }
        } else {
            if (!this.m_remove.isSelected(state) || data.get((Object)ASSIGNED) != null) return;
            data.addError("Please select a category to remove");
        }
    }

    private static void addFillerOption(OptionGroup o) {
        o.addOption(new Option("", FILLER_OPTION));
    }

    public static String getCategoryPath(Category c) {
        StringBuffer s = new StringBuffer();
        CategoryCollection ancestors = c.getDefaultAscendants();
        ancestors.addOrder("defaultAncestors");
        boolean isFirst = true;
        while (ancestors.next()) {
            if (!isFirst) {
                s.append(SEPARATOR);
            }
            s.append(ancestors.getCategory().getName());
            isFirst = false;
        }
        return s.toString();
    }

    protected static class CategoryMap
    extends SequentialMap {
        public void add(Category c) {
            super.put((Object)c.getID().toString(), (Object)c);
        }
    }

    @Deprecated
    private class AssignedPrintListener
    implements PrintListener {
        private AssignedPrintListener() {
        }

        public void prepare(PrintEvent e) {
            OptionGroup o = (OptionGroup)e.getTarget();
            PageState state = e.getPageState();
            CategoryMap m = CategoryForm.this.getAssignedCategories(state);
            if (!m.isEmpty()) {
                for (Category c : m.values()) {
                    o.addOption(new Option(c.getID().toString(), CategoryForm.getCategoryPath(c)));
                }
            } else {
                o.addOption(new Option("", "-- none --"));
            }
            CategoryForm.addFillerOption(o);
        }
    }

    private class FreePrintListener
    implements PrintListener {
        private FreePrintListener() {
        }

        public void prepare(PrintEvent e) {
            OptionGroup target = (OptionGroup)e.getTarget();
            PageState state = e.getPageState();
            Category root = CategoryForm.this.getRootCategory(state);
            if (root == null) {
                return;
            }
            Category excludedCat = CategoryForm.this.getExcludedCategory(state);
            CategoryMap excluded = new CategoryMap();
            if (excludedCat != null) {
                CategoryCollection excludedSubTree = CategoryForm.this.getExcludedCategory(state).getDescendants();
                while (excludedSubTree.next()) {
                    excluded.add(excludedSubTree.getCategory());
                }
            }
            CategoryMap assigned = CategoryForm.this.getAssignedCategories(state);
            TreeMap<String, String> sortedCats = new TreeMap<String, String>();
            CategoryCollection children = root.getDescendants();
            while (children.next()) {
                Category cat = children.getCategory();
                sortedCats.put(cat.getQualifiedName(CategoryForm.SEPARATOR, true), cat.getID().toString());
            }
            for (Map.Entry entry : sortedCats.entrySet()) {
                boolean notRoot;
                String path = (String)entry.getKey();
                String id = (String)entry.getValue();
                boolean notExcluded = excluded == null || !excluded.containsKey(id);
                boolean notAlreadyAssigned = !assigned.containsKey(id);
                boolean bl = notRoot = !id.equals(root.getID().toString());
                if (!notExcluded || !notAlreadyAssigned || !notRoot) continue;
                target.addOption(new Option(id, path));
            }
            CategoryForm.addFillerOption(target);
        }
    }
}

